@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network properties of a server.
 * @property delegatedSubnetResourceId Delegated subnet arm resource id. This is required to be passed during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for Private DNS zone.
 * @property privateDnsZoneArmResourceId Private dns zone arm resource id. This is required to be passed during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for Private DNS zone.
 * @property publicNetworkAccess public network access is enabled or not
 */
public data class NetworkResponse(
    public val delegatedSubnetResourceId: String? = null,
    public val privateDnsZoneArmResourceId: String? = null,
    public val publicNetworkAccess: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.NetworkResponse):
            NetworkResponse = NetworkResponse(
            delegatedSubnetResourceId = javaType.delegatedSubnetResourceId().map({ args0 ->
                args0
            }).orElse(null),
            privateDnsZoneArmResourceId = javaType.privateDnsZoneArmResourceId().map({ args0 ->
                args0
            }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess(),
        )
    }
}
