@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Storage properties of a server
 * @property storageSizeGB Max storage allowed for a server.
 */
public data class StorageResponse(
    public val storageSizeGB: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.StorageResponse):
            StorageResponse = StorageResponse(
            storageSizeGB = javaType.storageSizeGB().map({ args0 -> args0 }).orElse(null),
        )
    }
}
