@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin

import com.pulumi.azurenative.delegatednetwork.ControllerDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents an instance of a DNC controller.
 * Azure REST API version: 2021-03-15. Prior API version in Azure Native 1.x: 2021-03-15.
 * Other available API versions: 2023-05-18-preview, 2023-06-27-preview.
 * ## Example Usage
 * ### Create controller
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var controllerDetails = new AzureNative.DelegatedNetwork.ControllerDetails("controllerDetails", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "TestRG",
 *         ResourceName = "testcontroller",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/delegatednetwork/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := delegatednetwork.NewControllerDetails(ctx, "controllerDetails", &delegatednetwork.ControllerDetailsArgs{
 * 			Location:          pulumi.String("West US"),
 * 			ResourceGroupName: pulumi.String("TestRG"),
 * 			ResourceName:      pulumi.String("testcontroller"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.delegatednetwork.ControllerDetails;
 * import com.pulumi.azurenative.delegatednetwork.ControllerDetailsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var controllerDetails = new ControllerDetails("controllerDetails", ControllerDetailsArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("TestRG")
 *             .resourceName("testcontroller")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:delegatednetwork:ControllerDetails testcontroller /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DelegatedNetwork/controller/{resourceName}
 * ```
 * @property location Location of the resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property resourceName The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
 * @property tags The resource tags.
 */
public data class ControllerDetailsArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.delegatednetwork.ControllerDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.delegatednetwork.ControllerDetailsArgs =
        com.pulumi.azurenative.delegatednetwork.ControllerDetailsArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ControllerDetailsArgs].
 */
@PulumiTagMarker
public class ControllerDetailsArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Location of the resource.
     */
    @JvmName("vjbvqabysiwupelw")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fmvoweorrgfsrbaw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("heqhvrqjmyhitsfd")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("pkpmgmnmaqreridm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Location of the resource.
     */
    @JvmName("kltbfmbsxdruefwx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lkdgfvahyddujgpn")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the resource. It must be a minimum of 3 characters, and a maximum of 63.
     */
    @JvmName("fxkitstktuwsakvt")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value The resource tags.
     */
    @JvmName("jbcicfkrkfhdtpep")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The resource tags.
     */
    @JvmName("xgyvxsldkmacvyne")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ControllerDetailsArgs = ControllerDetailsArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
