@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.delegatednetwork.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property principalId The principal id of the system assigned identity which is used by orchestrator.
 * @property tenantId The tenant id of the system assigned identity which is used by orchestrator.
 * @property type The type of identity used for orchestrator cluster. Type 'SystemAssigned' will use an implicitly created identity orchestrator clusters
 */
public data class OrchestratorIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.delegatednetwork.outputs.OrchestratorIdentityResponse):
            OrchestratorIdentityResponse = OrchestratorIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
