@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin

import com.pulumi.azurenative.desktopvirtualization.ApplicationGroupArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.ApplicationGroupType
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetIdentityArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetPlanArgsBuilder
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgs
import com.pulumi.azurenative.desktopvirtualization.kotlin.inputs.ResourceModelWithAllowedPropertySetSkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a ApplicationGroup definition.
 * Azure REST API version: 2022-09-09. Prior API version in Azure Native 1.x: 2021-02-01-preview.
 * Other available API versions: 2020-11-10-preview, 2022-04-01-preview, 2022-10-14-preview, 2023-07-07-preview, 2023-09-05, 2023-10-04-preview, 2023-11-01-preview, 2024-01-16-preview.
 * ## Example Usage
 * ### ApplicationGroup_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var applicationGroup = new AzureNative.DesktopVirtualization.ApplicationGroup("applicationGroup", new()
 *     {
 *         ApplicationGroupName = "applicationGroup1",
 *         ApplicationGroupType = "RemoteApp",
 *         Description = "des1",
 *         FriendlyName = "friendly",
 *         HostPoolArmPath = "/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1",
 *         Location = "centralus",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/desktopvirtualization/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := desktopvirtualization.NewApplicationGroup(ctx, "applicationGroup", &desktopvirtualization.ApplicationGroupArgs{
 * 			ApplicationGroupName: pulumi.String("applicationGroup1"),
 * 			ApplicationGroupType: pulumi.String("RemoteApp"),
 * 			Description:          pulumi.String("des1"),
 * 			FriendlyName:         pulumi.String("friendly"),
 * 			HostPoolArmPath:      pulumi.String("/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1"),
 * 			Location:             pulumi.String("centralus"),
 * 			ResourceGroupName:    pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.desktopvirtualization.ApplicationGroup;
 * import com.pulumi.azurenative.desktopvirtualization.ApplicationGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var applicationGroup = new ApplicationGroup("applicationGroup", ApplicationGroupArgs.builder()
 *             .applicationGroupName("applicationGroup1")
 *             .applicationGroupType("RemoteApp")
 *             .description("des1")
 *             .friendlyName("friendly")
 *             .hostPoolArmPath("/subscriptions/daefabc0-95b4-48b3-b645-8a753a63c4fa/resourceGroups/resourceGroup1/providers/Microsoft.DesktopVirtualization/hostPools/hostPool1")
 *             .location("centralus")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:desktopvirtualization:ApplicationGroup applicationGroup1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/applicationGroups/{applicationGroupName}
 * ```
 * @property applicationGroupName The name of the application group
 * @property applicationGroupType Resource Type of ApplicationGroup.
 * @property description Description of ApplicationGroup.
 * @property friendlyName Friendly name of ApplicationGroup.
 * @property hostPoolArmPath HostPool arm path of ApplicationGroup.
 * @property identity
 * @property kind Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
 * @property location The geo-location where the resource lives
 * @property managedBy The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
 * @property plan
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku
 * @property tags Resource tags.
 */
public data class ApplicationGroupArgs(
    public val applicationGroupName: Output<String>? = null,
    public val applicationGroupType: Output<Either<String, ApplicationGroupType>>? = null,
    public val description: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val hostPoolArmPath: Output<String>? = null,
    public val identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null,
    public val kind: Output<String>? = null,
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.ApplicationGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.ApplicationGroupArgs =
        com.pulumi.azurenative.desktopvirtualization.ApplicationGroupArgs.builder()
            .applicationGroupName(applicationGroupName?.applyValue({ args0 -> args0 }))
            .applicationGroupType(
                applicationGroupType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .hostPoolArmPath(hostPoolArmPath?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .plan(plan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ApplicationGroupArgs].
 */
@PulumiTagMarker
public class ApplicationGroupArgsBuilder internal constructor() {
    private var applicationGroupName: Output<String>? = null

    private var applicationGroupType: Output<Either<String, ApplicationGroupType>>? = null

    private var description: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var hostPoolArmPath: Output<String>? = null

    private var identity: Output<ResourceModelWithAllowedPropertySetIdentityArgs>? = null

    private var kind: Output<String>? = null

    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var plan: Output<ResourceModelWithAllowedPropertySetPlanArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<ResourceModelWithAllowedPropertySetSkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the application group
     */
    @JvmName("bglnvaepslbffnwr")
    public suspend fun applicationGroupName(`value`: Output<String>) {
        this.applicationGroupName = value
    }

    /**
     * @param value Resource Type of ApplicationGroup.
     */
    @JvmName("bvbwdfftokcarsbd")
    public suspend fun applicationGroupType(`value`: Output<Either<String, ApplicationGroupType>>) {
        this.applicationGroupType = value
    }

    /**
     * @param value Description of ApplicationGroup.
     */
    @JvmName("sfkwspfdibccallc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Friendly name of ApplicationGroup.
     */
    @JvmName("biealadguwjbrsim")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value HostPool arm path of ApplicationGroup.
     */
    @JvmName("yuvieirpojmuyray")
    public suspend fun hostPoolArmPath(`value`: Output<String>) {
        this.hostPoolArmPath = value
    }

    /**
     * @param value
     */
    @JvmName("jsvtmjkovvftctck")
    public suspend fun identity(`value`: Output<ResourceModelWithAllowedPropertySetIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("yrwjcsnmlquihnyo")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("sgfleibhhcbuqspl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("rwuykefkxwgbqrfx")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value
     */
    @JvmName("vnoyxftqcpyomalm")
    public suspend fun plan(`value`: Output<ResourceModelWithAllowedPropertySetPlanArgs>) {
        this.plan = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("glqluwyeimunkctm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value
     */
    @JvmName("sxjxmbpyvsgckiut")
    public suspend fun sku(`value`: Output<ResourceModelWithAllowedPropertySetSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("sydnxqlncgulfdpo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the application group
     */
    @JvmName("frhvaccwmivroxxi")
    public suspend fun applicationGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGroupName = mapped
    }

    /**
     * @param value Resource Type of ApplicationGroup.
     */
    @JvmName("invofqousgaordnj")
    public suspend fun applicationGroupType(`value`: Either<String, ApplicationGroupType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationGroupType = mapped
    }

    /**
     * @param value Resource Type of ApplicationGroup.
     */
    @JvmName("oaehjuhpxtyfgkmn")
    public fun applicationGroupType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ApplicationGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGroupType = mapped
    }

    /**
     * @param value Resource Type of ApplicationGroup.
     */
    @JvmName("osnigvlcnoqcajnq")
    public fun applicationGroupType(`value`: ApplicationGroupType) {
        val toBeMapped = Either.ofRight<String, ApplicationGroupType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.applicationGroupType = mapped
    }

    /**
     * @param value Description of ApplicationGroup.
     */
    @JvmName("tygpmwtqgitbjlvi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Friendly name of ApplicationGroup.
     */
    @JvmName("xsvgjbbvfjnkvept")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value HostPool arm path of ApplicationGroup.
     */
    @JvmName("ewwthoqiufcxjaik")
    public suspend fun hostPoolArmPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostPoolArmPath = mapped
    }

    /**
     * @param value
     */
    @JvmName("epuuspcbhoynpvkj")
    public suspend fun identity(`value`: ResourceModelWithAllowedPropertySetIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument
     */
    @JvmName("guwgrgdwhlscpdro")
    public suspend
    fun identity(argument: suspend ResourceModelWithAllowedPropertySetIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetIdentityArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Metadata used by portal/tooling/etc to render different UX experiences for resources of the same type; e.g. ApiApps are a kind of Microsoft.Web/sites type.  If supported, the resource provider must validate and persist this value.
     */
    @JvmName("sewaolklyrldwabj")
    public suspend fun kind(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fpyywbbwwgkqdhkh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The fully qualified resource ID of the resource that manages this resource. Indicates if this resource is managed by another Azure resource. If this is present, complete mode deployment will not delete the resource if it is removed from the template since it is managed by another resource.
     */
    @JvmName("fthnftbtecnvorxs")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value
     */
    @JvmName("jcbbobweoqhswqgt")
    public suspend fun plan(`value`: ResourceModelWithAllowedPropertySetPlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.plan = mapped
    }

    /**
     * @param argument
     */
    @JvmName("xotmipfevgyuagoj")
    public suspend
    fun plan(argument: suspend ResourceModelWithAllowedPropertySetPlanArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetPlanArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.plan = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("qqkgnvjpglernspc")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value
     */
    @JvmName("nmbsiwkytuqafmfw")
    public suspend fun sku(`value`: ResourceModelWithAllowedPropertySetSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument
     */
    @JvmName("ybqecyuvahbttcci")
    public suspend
    fun sku(argument: suspend ResourceModelWithAllowedPropertySetSkuArgsBuilder.() -> Unit) {
        val toBeMapped = ResourceModelWithAllowedPropertySetSkuArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("asitksfjuuiwcjkj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("vkamtbmyuefwsuvh")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ApplicationGroupArgs = ApplicationGroupArgs(
        applicationGroupName = applicationGroupName,
        applicationGroupType = applicationGroupType,
        description = description,
        friendlyName = friendlyName,
        hostPoolArmPath = hostPoolArmPath,
        identity = identity,
        kind = kind,
        location = location,
        managedBy = managedBy,
        plan = plan,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
