@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * HostPool type for desktop.
 */
public enum class ScalingHostPoolType(
    public val javaValue: com.pulumi.azurenative.desktopvirtualization.enums.ScalingHostPoolType,
) : ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.enums.ScalingHostPoolType> {
    /**
     * Users get a new (random) SessionHost every time it connects to the HostPool.
     */
    Pooled(com.pulumi.azurenative.desktopvirtualization.enums.ScalingHostPoolType.Pooled),
    ;

    override fun toJava(): com.pulumi.azurenative.desktopvirtualization.enums.ScalingHostPoolType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.enums.ScalingHostPoolType):
            ScalingHostPoolType = ScalingHostPoolType.values().first { it.javaValue == javaType }
    }
}
