@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.GetApplicationGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationGroupName The name of the application group
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetApplicationGroupPlainArgs(
    public val applicationGroupName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.GetApplicationGroupPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.GetApplicationGroupPlainArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.GetApplicationGroupPlainArgs.builder()
            .applicationGroupName(applicationGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationGroupPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationGroupPlainArgsBuilder internal constructor() {
    private var applicationGroupName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the application group
     */
    @JvmName("ocpjvifxowrqbdav")
    public suspend fun applicationGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationGroupName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vcuindxypegmvtbd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationGroupPlainArgs = GetApplicationGroupPlainArgs(
        applicationGroupName = applicationGroupName ?: throw
            PulumiNullFieldException("applicationGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
