@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.GetPrivateEndpointConnectionByHostPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hostPoolName The name of the host pool within the specified resource group
 * @property privateEndpointConnectionName The name of the private endpoint connection associated with the Azure resource
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPrivateEndpointConnectionByHostPoolPlainArgs(
    public val hostPoolName: String,
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.GetPrivateEndpointConnectionByHostPoolPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.GetPrivateEndpointConnectionByHostPoolPlainArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.GetPrivateEndpointConnectionByHostPoolPlainArgs.builder()
            .hostPoolName(hostPoolName.let({ args0 -> args0 }))
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionByHostPoolPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionByHostPoolPlainArgsBuilder internal constructor() {
    private var hostPoolName: String? = null

    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the host pool within the specified resource group
     */
    @JvmName("kyxosihaqnowgogv")
    public suspend fun hostPoolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hostPoolName = mapped
    }

    /**
     * @param value The name of the private endpoint connection associated with the Azure resource
     */
    @JvmName("kuhhmyrijgrnqojv")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lqahjiekysvslqnf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionByHostPoolPlainArgs =
        GetPrivateEndpointConnectionByHostPoolPlainArgs(
            hostPoolName = hostPoolName ?: throw PulumiNullFieldException("hostPoolName"),
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
