@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.MaintenanceWindowPropertiesArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.DayOfWeek
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Maintenance window starting hour and day of week.
 * @property dayOfWeek Day of the week.
 * @property hour The update start hour of the day. (0 - 23)
 */
public data class MaintenanceWindowPropertiesArgs(
    public val dayOfWeek: Output<DayOfWeek>? = null,
    public val hour: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.MaintenanceWindowPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.MaintenanceWindowPropertiesArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.MaintenanceWindowPropertiesArgs.builder()
            .dayOfWeek(dayOfWeek?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .hour(hour?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MaintenanceWindowPropertiesArgs].
 */
@PulumiTagMarker
public class MaintenanceWindowPropertiesArgsBuilder internal constructor() {
    private var dayOfWeek: Output<DayOfWeek>? = null

    private var hour: Output<Int>? = null

    /**
     * @param value Day of the week.
     */
    @JvmName("embtccjotkmgbxre")
    public suspend fun dayOfWeek(`value`: Output<DayOfWeek>) {
        this.dayOfWeek = value
    }

    /**
     * @param value The update start hour of the day. (0 - 23)
     */
    @JvmName("stuyityvxjgjpfda")
    public suspend fun hour(`value`: Output<Int>) {
        this.hour = value
    }

    /**
     * @param value Day of the week.
     */
    @JvmName("xrwwqhpnirjubbcp")
    public suspend fun dayOfWeek(`value`: DayOfWeek?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dayOfWeek = mapped
    }

    /**
     * @param value The update start hour of the day. (0 - 23)
     */
    @JvmName("kchokkhcqbvbcfly")
    public suspend fun hour(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hour = mapped
    }

    internal fun build(): MaintenanceWindowPropertiesArgs = MaintenanceWindowPropertiesArgs(
        dayOfWeek = dayOfWeek,
        hour = hour,
    )
}
