@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageApplicationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Schema for MSIX Package Application properties.
 * @property appId Package Application Id, found in appxmanifest.xml.
 * @property appUserModelID Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
 * @property description Description of Package Application.
 * @property friendlyName User friendly name.
 * @property iconImageName User friendly name.
 * @property rawIcon the icon a 64 bit string as a byte array.
 * @property rawPng the icon a 64 bit string as a byte array.
 */
public data class MsixPackageApplicationsArgs(
    public val appId: Output<String>? = null,
    public val appUserModelID: Output<String>? = null,
    public val description: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val iconImageName: Output<String>? = null,
    public val rawIcon: Output<String>? = null,
    public val rawPng: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageApplicationsArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageApplicationsArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.MsixPackageApplicationsArgs.builder()
            .appId(appId?.applyValue({ args0 -> args0 }))
            .appUserModelID(appUserModelID?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .iconImageName(iconImageName?.applyValue({ args0 -> args0 }))
            .rawIcon(rawIcon?.applyValue({ args0 -> args0 }))
            .rawPng(rawPng?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MsixPackageApplicationsArgs].
 */
@PulumiTagMarker
public class MsixPackageApplicationsArgsBuilder internal constructor() {
    private var appId: Output<String>? = null

    private var appUserModelID: Output<String>? = null

    private var description: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var iconImageName: Output<String>? = null

    private var rawIcon: Output<String>? = null

    private var rawPng: Output<String>? = null

    /**
     * @param value Package Application Id, found in appxmanifest.xml.
     */
    @JvmName("sukttdcwgklsolge")
    public suspend fun appId(`value`: Output<String>) {
        this.appId = value
    }

    /**
     * @param value Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
     */
    @JvmName("qugkvpslgxavxoco")
    public suspend fun appUserModelID(`value`: Output<String>) {
        this.appUserModelID = value
    }

    /**
     * @param value Description of Package Application.
     */
    @JvmName("fradqmxcqbmnceta")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value User friendly name.
     */
    @JvmName("jhmissskhvsobpvq")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value User friendly name.
     */
    @JvmName("meixgwswiyqfqoio")
    public suspend fun iconImageName(`value`: Output<String>) {
        this.iconImageName = value
    }

    /**
     * @param value the icon a 64 bit string as a byte array.
     */
    @JvmName("upkvlyyhpaiakbuo")
    public suspend fun rawIcon(`value`: Output<String>) {
        this.rawIcon = value
    }

    /**
     * @param value the icon a 64 bit string as a byte array.
     */
    @JvmName("jplgtjecmroxptfw")
    public suspend fun rawPng(`value`: Output<String>) {
        this.rawPng = value
    }

    /**
     * @param value Package Application Id, found in appxmanifest.xml.
     */
    @JvmName("mskmilgarhhpawrn")
    public suspend fun appId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appId = mapped
    }

    /**
     * @param value Used to activate Package Application. Consists of Package Name and ApplicationID. Found in appxmanifest.xml.
     */
    @JvmName("nvwvkgiyxgqpcxuf")
    public suspend fun appUserModelID(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appUserModelID = mapped
    }

    /**
     * @param value Description of Package Application.
     */
    @JvmName("yiybiciguwdpbqoi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value User friendly name.
     */
    @JvmName("pcpkvmsrpcafpsna")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value User friendly name.
     */
    @JvmName("mgtoofvqoysdhfcr")
    public suspend fun iconImageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iconImageName = mapped
    }

    /**
     * @param value the icon a 64 bit string as a byte array.
     */
    @JvmName("jgwchcajqwjksmnn")
    public suspend fun rawIcon(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rawIcon = mapped
    }

    /**
     * @param value the icon a 64 bit string as a byte array.
     */
    @JvmName("stygdbvgypslpgdm")
    public suspend fun rawPng(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rawPng = mapped
    }

    internal fun build(): MsixPackageApplicationsArgs = MsixPackageApplicationsArgs(
        appId = appId,
        appUserModelID = appUserModelID,
        description = description,
        friendlyName = friendlyName,
        iconImageName = iconImageName,
        rawIcon = rawIcon,
        rawPng = rawPng,
    )
}
