@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetIdentityArgs.builder
import com.pulumi.azurenative.desktopvirtualization.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type The identity type.
 */
public data class ResourceModelWithAllowedPropertySetIdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetIdentityArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetIdentityArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetIdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ResourceModelWithAllowedPropertySetIdentityArgs].
 */
@PulumiTagMarker
public class ResourceModelWithAllowedPropertySetIdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("awypfjlrntjqfpiy")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("jjlvkngsfnbbymvr")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ResourceModelWithAllowedPropertySetIdentityArgs =
        ResourceModelWithAllowedPropertySetIdentityArgs(
            type = type,
        )
}
