@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.inputs

import com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetPlanArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name A user defined name of the 3rd Party Artifact that is being procured.
 * @property product The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
 * @property promotionCode A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
 * @property publisher The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
 * @property version The version of the desired product/artifact.
 */
public data class ResourceModelWithAllowedPropertySetPlanArgs(
    public val name: Output<String>,
    public val product: Output<String>,
    public val promotionCode: Output<String>? = null,
    public val publisher: Output<String>,
    public val version: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetPlanArgs> {
    override fun toJava():
        com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetPlanArgs =
        com.pulumi.azurenative.desktopvirtualization.inputs.ResourceModelWithAllowedPropertySetPlanArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .product(product.applyValue({ args0 -> args0 }))
            .promotionCode(promotionCode?.applyValue({ args0 -> args0 }))
            .publisher(publisher.applyValue({ args0 -> args0 }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceModelWithAllowedPropertySetPlanArgs].
 */
@PulumiTagMarker
public class ResourceModelWithAllowedPropertySetPlanArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var product: Output<String>? = null

    private var promotionCode: Output<String>? = null

    private var publisher: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value A user defined name of the 3rd Party Artifact that is being procured.
     */
    @JvmName("fafqesmevvjxgrjg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
     */
    @JvmName("nbnksaeswhdyelwb")
    public suspend fun product(`value`: Output<String>) {
        this.product = value
    }

    /**
     * @param value A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
     */
    @JvmName("llkopqkuplusdnjv")
    public suspend fun promotionCode(`value`: Output<String>) {
        this.promotionCode = value
    }

    /**
     * @param value The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
     */
    @JvmName("mhhkbpdlsucoyrbn")
    public suspend fun publisher(`value`: Output<String>) {
        this.publisher = value
    }

    /**
     * @param value The version of the desired product/artifact.
     */
    @JvmName("veqokghcjpbumbxb")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value A user defined name of the 3rd Party Artifact that is being procured.
     */
    @JvmName("dspfcmxbfogvaext")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The 3rd Party artifact that is being procured. E.g. NewRelic. Product maps to the OfferID specified for the artifact at the time of Data Market onboarding.
     */
    @JvmName("ijylwvaqpapxwqfv")
    public suspend fun product(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.product = mapped
    }

    /**
     * @param value A publisher provided promotion code as provisioned in Data Market for the said product/artifact.
     */
    @JvmName("hpqcvgprvraebxov")
    public suspend fun promotionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.promotionCode = mapped
    }

    /**
     * @param value The publisher of the 3rd Party Artifact that is being bought. E.g. NewRelic
     */
    @JvmName("lerlgytiftrouxvy")
    public suspend fun publisher(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publisher = mapped
    }

    /**
     * @param value The version of the desired product/artifact.
     */
    @JvmName("nyhnxaykhtffdhdl")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ResourceModelWithAllowedPropertySetPlanArgs =
        ResourceModelWithAllowedPropertySetPlanArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            product = product ?: throw PulumiNullFieldException("product"),
            promotionCode = promotionCode,
            publisher = publisher ?: throw PulumiNullFieldException("publisher"),
            version = version,
        )
}
