@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Represents a ScalingPlanPersonalSchedule definition.
 * @property daysOfWeek Set of days of the week on which this schedule is active.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property offPeakActionOnDisconnect Action to be taken after a user disconnect during the off-peak period.
 * @property offPeakActionOnLogoff Action to be taken after a logoff during the off-peak period.
 * @property offPeakMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the off-peak period.
 * @property offPeakMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the off-peak period.
 * @property offPeakStartTime Starting time for off-peak period.
 * @property offPeakStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the off-peak phase.
 * @property peakActionOnDisconnect Action to be taken after a user disconnect during the peak period.
 * @property peakActionOnLogoff Action to be taken after a logoff during the peak period.
 * @property peakMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the peak period.
 * @property peakMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the peak period.
 * @property peakStartTime Starting time for peak period.
 * @property peakStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the peak phase.
 * @property rampDownActionOnDisconnect Action to be taken after a user disconnect during the ramp down period.
 * @property rampDownActionOnLogoff Action to be taken after a logoff during the ramp down period.
 * @property rampDownMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp down period.
 * @property rampDownMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp down period.
 * @property rampDownStartTime Starting time for ramp down period.
 * @property rampDownStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the ramp down phase.
 * @property rampUpActionOnDisconnect Action to be taken after a user disconnect during the ramp up period.
 * @property rampUpActionOnLogoff Action to be taken after a logoff during the ramp up period.
 * @property rampUpAutoStartHosts The desired startup behavior during the ramp up period for personal vms in the hostpool.
 * @property rampUpMinutesToWaitOnDisconnect The time in minutes to wait before performing the desired session handling action when a user disconnects during the ramp up period.
 * @property rampUpMinutesToWaitOnLogoff The time in minutes to wait before performing the desired session handling action when a user logs off during the ramp up period.
 * @property rampUpStartTime Starting time for ramp up period.
 * @property rampUpStartVMOnConnect The desired configuration of Start VM On Connect for the hostpool during the ramp up phase. If this is disabled, session hosts must be turned on using rampUpAutoStartHosts or by turning them on manually.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetScalingPlanPersonalScheduleResult(
    public val daysOfWeek: List<String>? = null,
    public val id: String,
    public val name: String,
    public val offPeakActionOnDisconnect: String? = null,
    public val offPeakActionOnLogoff: String? = null,
    public val offPeakMinutesToWaitOnDisconnect: Int? = null,
    public val offPeakMinutesToWaitOnLogoff: Int? = null,
    public val offPeakStartTime: TimeResponse? = null,
    public val offPeakStartVMOnConnect: String? = null,
    public val peakActionOnDisconnect: String? = null,
    public val peakActionOnLogoff: String? = null,
    public val peakMinutesToWaitOnDisconnect: Int? = null,
    public val peakMinutesToWaitOnLogoff: Int? = null,
    public val peakStartTime: TimeResponse? = null,
    public val peakStartVMOnConnect: String? = null,
    public val rampDownActionOnDisconnect: String? = null,
    public val rampDownActionOnLogoff: String? = null,
    public val rampDownMinutesToWaitOnDisconnect: Int? = null,
    public val rampDownMinutesToWaitOnLogoff: Int? = null,
    public val rampDownStartTime: TimeResponse? = null,
    public val rampDownStartVMOnConnect: String? = null,
    public val rampUpActionOnDisconnect: String? = null,
    public val rampUpActionOnLogoff: String? = null,
    public val rampUpAutoStartHosts: String? = null,
    public val rampUpMinutesToWaitOnDisconnect: Int? = null,
    public val rampUpMinutesToWaitOnLogoff: Int? = null,
    public val rampUpStartTime: TimeResponse? = null,
    public val rampUpStartVMOnConnect: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.GetScalingPlanPersonalScheduleResult):
            GetScalingPlanPersonalScheduleResult = GetScalingPlanPersonalScheduleResult(
            daysOfWeek = javaType.daysOfWeek().map({ args0 -> args0 }),
            id = javaType.id(),
            name = javaType.name(),
            offPeakActionOnDisconnect = javaType.offPeakActionOnDisconnect().map({ args0 ->
                args0
            }).orElse(null),
            offPeakActionOnLogoff = javaType.offPeakActionOnLogoff().map({ args0 -> args0 }).orElse(null),
            offPeakMinutesToWaitOnDisconnect = javaType.offPeakMinutesToWaitOnDisconnect().map({ args0 ->
                args0
            }).orElse(null),
            offPeakMinutesToWaitOnLogoff = javaType.offPeakMinutesToWaitOnLogoff().map({ args0 ->
                args0
            }).orElse(null),
            offPeakStartTime = javaType.offPeakStartTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            offPeakStartVMOnConnect = javaType.offPeakStartVMOnConnect().map({ args0 -> args0 }).orElse(null),
            peakActionOnDisconnect = javaType.peakActionOnDisconnect().map({ args0 -> args0 }).orElse(null),
            peakActionOnLogoff = javaType.peakActionOnLogoff().map({ args0 -> args0 }).orElse(null),
            peakMinutesToWaitOnDisconnect = javaType.peakMinutesToWaitOnDisconnect().map({ args0 ->
                args0
            }).orElse(null),
            peakMinutesToWaitOnLogoff = javaType.peakMinutesToWaitOnLogoff().map({ args0 ->
                args0
            }).orElse(null),
            peakStartTime = javaType.peakStartTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            peakStartVMOnConnect = javaType.peakStartVMOnConnect().map({ args0 -> args0 }).orElse(null),
            rampDownActionOnDisconnect = javaType.rampDownActionOnDisconnect().map({ args0 ->
                args0
            }).orElse(null),
            rampDownActionOnLogoff = javaType.rampDownActionOnLogoff().map({ args0 -> args0 }).orElse(null),
            rampDownMinutesToWaitOnDisconnect = javaType.rampDownMinutesToWaitOnDisconnect().map({ args0 ->
                args0
            }).orElse(null),
            rampDownMinutesToWaitOnLogoff = javaType.rampDownMinutesToWaitOnLogoff().map({ args0 ->
                args0
            }).orElse(null),
            rampDownStartTime = javaType.rampDownStartTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rampDownStartVMOnConnect = javaType.rampDownStartVMOnConnect().map({ args0 -> args0 }).orElse(null),
            rampUpActionOnDisconnect = javaType.rampUpActionOnDisconnect().map({ args0 -> args0 }).orElse(null),
            rampUpActionOnLogoff = javaType.rampUpActionOnLogoff().map({ args0 -> args0 }).orElse(null),
            rampUpAutoStartHosts = javaType.rampUpAutoStartHosts().map({ args0 -> args0 }).orElse(null),
            rampUpMinutesToWaitOnDisconnect = javaType.rampUpMinutesToWaitOnDisconnect().map({ args0 ->
                args0
            }).orElse(null),
            rampUpMinutesToWaitOnLogoff = javaType.rampUpMinutesToWaitOnLogoff().map({ args0 ->
                args0
            }).orElse(null),
            rampUpStartTime = javaType.rampUpStartTime().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.TimeResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rampUpStartVMOnConnect = javaType.rampUpStartVMOnConnect().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.desktopvirtualization.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
