@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.desktopvirtualization.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Scaling plan reference to hostpool.
 * @property hostPoolArmPath Arm path of referenced hostpool.
 * @property scalingPlanEnabled Is the scaling plan enabled for this hostpool.
 */
public data class ScalingHostPoolReferenceResponse(
    public val hostPoolArmPath: String? = null,
    public val scalingPlanEnabled: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.desktopvirtualization.outputs.ScalingHostPoolReferenceResponse):
            ScalingHostPoolReferenceResponse = ScalingHostPoolReferenceResponse(
            hostPoolArmPath = javaType.hostPoolArmPath().map({ args0 -> args0 }).orElse(null),
            scalingPlanEnabled = javaType.scalingPlanEnabled().map({ args0 -> args0 }).orElse(null),
        )
    }
}
