@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin

import com.pulumi.azurenative.devcenter.DevBoxDefinitionArgs.builder
import com.pulumi.azurenative.devcenter.kotlin.enums.HibernateSupport
import com.pulumi.azurenative.devcenter.kotlin.inputs.ImageReferenceArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.ImageReferenceArgsBuilder
import com.pulumi.azurenative.devcenter.kotlin.inputs.SkuArgs
import com.pulumi.azurenative.devcenter.kotlin.inputs.SkuArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents a definition for a Developer Machine.
 * Azure REST API version: 2023-04-01. Prior API version in Azure Native 1.x: 2022-09-01-preview.
 * Other available API versions: 2022-11-11-preview, 2023-08-01-preview, 2023-10-01-preview.
 * ## Example Usage
 * ### DevBoxDefinitions_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var devBoxDefinition = new AzureNative.DevCenter.DevBoxDefinition("devBoxDefinition", new()
 *     {
 *         DevBoxDefinitionName = "WebDevBox",
 *         DevCenterName = "Contoso",
 *         HibernateSupport = "Enabled",
 *         ImageReference = new AzureNative.DevCenter.Inputs.ImageReferenceArgs
 *         {
 *             Id = "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/Example/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/contosogallery/images/exampleImage/version/1.0.0",
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "rg1",
 *         Sku = new AzureNative.DevCenter.Inputs.SkuArgs
 *         {
 *             Name = "Preview",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devcenter/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devcenter.NewDevBoxDefinition(ctx, "devBoxDefinition", &devcenter.DevBoxDefinitionArgs{
 * 			DevBoxDefinitionName: pulumi.String("WebDevBox"),
 * 			DevCenterName:        pulumi.String("Contoso"),
 * 			HibernateSupport:     pulumi.String("Enabled"),
 * 			ImageReference: &devcenter.ImageReferenceArgs{
 * 				Id: pulumi.String("/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/Example/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/contosogallery/images/exampleImage/version/1.0.0"),
 * 			},
 * 			Location:          pulumi.String("centralus"),
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Sku: &devcenter.SkuArgs{
 * 				Name: pulumi.String("Preview"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devcenter.DevBoxDefinition;
 * import com.pulumi.azurenative.devcenter.DevBoxDefinitionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var devBoxDefinition = new DevBoxDefinition("devBoxDefinition", DevBoxDefinitionArgs.builder()
 *             .devBoxDefinitionName("WebDevBox")
 *             .devCenterName("Contoso")
 *             .hibernateSupport("Enabled")
 *             .imageReference(Map.of("id", "/subscriptions/0ac520ee-14c0-480f-b6c9-0a90c58ffff/resourceGroups/Example/providers/Microsoft.DevCenter/devcenters/Contoso/galleries/contosogallery/images/exampleImage/version/1.0.0"))
 *             .location("centralus")
 *             .resourceGroupName("rg1")
 *             .sku(Map.of("name", "Preview"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devcenter:DevBoxDefinition WebDevBox /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevCenter/devcenters/{devCenterName}/devboxdefinitions/{devBoxDefinitionName}
 * ```
 * @property devBoxDefinitionName The name of the Dev Box definition.
 * @property devCenterName The name of the devcenter.
 * @property hibernateSupport Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate
 * @property imageReference Image reference information.
 * @property location The geo-location where the resource lives
 * @property osStorageType The storage type used for the Operating System disk of Dev Boxes created using this definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sku The SKU for Dev Boxes created using this definition.
 * @property tags Resource tags.
 */
public data class DevBoxDefinitionArgs(
    public val devBoxDefinitionName: Output<String>? = null,
    public val devCenterName: Output<String>? = null,
    public val hibernateSupport: Output<Either<String, HibernateSupport>>? = null,
    public val imageReference: Output<ImageReferenceArgs>? = null,
    public val location: Output<String>? = null,
    public val osStorageType: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sku: Output<SkuArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.DevBoxDefinitionArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.DevBoxDefinitionArgs =
        com.pulumi.azurenative.devcenter.DevBoxDefinitionArgs.builder()
            .devBoxDefinitionName(devBoxDefinitionName?.applyValue({ args0 -> args0 }))
            .devCenterName(devCenterName?.applyValue({ args0 -> args0 }))
            .hibernateSupport(
                hibernateSupport?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .imageReference(imageReference?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .osStorageType(osStorageType?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [DevBoxDefinitionArgs].
 */
@PulumiTagMarker
public class DevBoxDefinitionArgsBuilder internal constructor() {
    private var devBoxDefinitionName: Output<String>? = null

    private var devCenterName: Output<String>? = null

    private var hibernateSupport: Output<Either<String, HibernateSupport>>? = null

    private var imageReference: Output<ImageReferenceArgs>? = null

    private var location: Output<String>? = null

    private var osStorageType: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sku: Output<SkuArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the Dev Box definition.
     */
    @JvmName("rdilhmbfksfpvwxr")
    public suspend fun devBoxDefinitionName(`value`: Output<String>) {
        this.devBoxDefinitionName = value
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("tltllxvusobiidqj")
    public suspend fun devCenterName(`value`: Output<String>) {
        this.devCenterName = value
    }

    /**
     * @param value Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate
     */
    @JvmName("imuewhelrdohlljr")
    public suspend fun hibernateSupport(`value`: Output<Either<String, HibernateSupport>>) {
        this.hibernateSupport = value
    }

    /**
     * @param value Image reference information.
     */
    @JvmName("kngdhqvlidlwmqch")
    public suspend fun imageReference(`value`: Output<ImageReferenceArgs>) {
        this.imageReference = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("aeubvagspvgplwww")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The storage type used for the Operating System disk of Dev Boxes created using this definition.
     */
    @JvmName("lhfhoucytymhftiy")
    public suspend fun osStorageType(`value`: Output<String>) {
        this.osStorageType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("kmlwbpjbkffctagw")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The SKU for Dev Boxes created using this definition.
     */
    @JvmName("gvsqsuecayjpkpry")
    public suspend fun sku(`value`: Output<SkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("yvhigrpbqnbghpnl")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the Dev Box definition.
     */
    @JvmName("qhncuuknctjraymn")
    public suspend fun devBoxDefinitionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devBoxDefinitionName = mapped
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("cwlavjedskyychny")
    public suspend fun devCenterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.devCenterName = mapped
    }

    /**
     * @param value Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate
     */
    @JvmName("ijxvpjmovklgchld")
    public suspend fun hibernateSupport(`value`: Either<String, HibernateSupport>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hibernateSupport = mapped
    }

    /**
     * @param value Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate
     */
    @JvmName("kavaekvlqcndcjmg")
    public fun hibernateSupport(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HibernateSupport>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hibernateSupport = mapped
    }

    /**
     * @param value Indicates whether Dev Boxes created with this definition are capable of hibernation. Not all images are capable of supporting hibernation. To find out more see https://aka.ms/devbox/hibernate
     */
    @JvmName("ctmafpbauyouxrit")
    public fun hibernateSupport(`value`: HibernateSupport) {
        val toBeMapped = Either.ofRight<String, HibernateSupport>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.hibernateSupport = mapped
    }

    /**
     * @param value Image reference information.
     */
    @JvmName("maihbkfsipoxgrsu")
    public suspend fun imageReference(`value`: ImageReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageReference = mapped
    }

    /**
     * @param argument Image reference information.
     */
    @JvmName("eikifbgitkdieoxq")
    public suspend fun imageReference(argument: suspend ImageReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ImageReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.imageReference = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("uacueyhtsduepxjc")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The storage type used for the Operating System disk of Dev Boxes created using this definition.
     */
    @JvmName("fblcgnqbgbduxsfs")
    public suspend fun osStorageType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.osStorageType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fgeouylsiosgmxda")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The SKU for Dev Boxes created using this definition.
     */
    @JvmName("cpwcagncnutitkmr")
    public suspend fun sku(`value`: SkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The SKU for Dev Boxes created using this definition.
     */
    @JvmName("hshjocsdeeeugirc")
    public suspend fun sku(argument: suspend SkuArgsBuilder.() -> Unit) {
        val toBeMapped = SkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("knlgshvttdyoahab")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wlejkwvfsoansqan")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DevBoxDefinitionArgs = DevBoxDefinitionArgs(
        devBoxDefinitionName = devBoxDefinitionName,
        devCenterName = devCenterName,
        hibernateSupport = hibernateSupport,
        imageReference = imageReference,
        location = location,
        osStorageType = osStorageType,
        resourceGroupName = resourceGroupName,
        sku = sku,
        tags = tags,
    )
}
