@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetDevCenterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property devCenterName The name of the devcenter.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDevCenterPlainArgs(
    public val devCenterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetDevCenterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetDevCenterPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetDevCenterPlainArgs.builder()
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDevCenterPlainArgs].
 */
@PulumiTagMarker
public class GetDevCenterPlainArgsBuilder internal constructor() {
    private var devCenterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("guaerfaatjprvqjo")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("uhhxgdgfdxpwmbvr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDevCenterPlainArgs = GetDevCenterPlainArgs(
        devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
