@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetEnvironmentDefinitionErrorDetailsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property catalogName The name of the Catalog.
 * @property devCenterName The name of the devcenter.
 * @property environmentDefinitionName The name of the Environment Definition.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetEnvironmentDefinitionErrorDetailsPlainArgs(
    public val catalogName: String,
    public val devCenterName: String,
    public val environmentDefinitionName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetEnvironmentDefinitionErrorDetailsPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.devcenter.inputs.GetEnvironmentDefinitionErrorDetailsPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetEnvironmentDefinitionErrorDetailsPlainArgs.builder()
            .catalogName(catalogName.let({ args0 -> args0 }))
            .devCenterName(devCenterName.let({ args0 -> args0 }))
            .environmentDefinitionName(environmentDefinitionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetEnvironmentDefinitionErrorDetailsPlainArgs].
 */
@PulumiTagMarker
public class GetEnvironmentDefinitionErrorDetailsPlainArgsBuilder internal constructor() {
    private var catalogName: String? = null

    private var devCenterName: String? = null

    private var environmentDefinitionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Catalog.
     */
    @JvmName("vwpbtiogdinymjyp")
    public suspend fun catalogName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.catalogName = mapped
    }

    /**
     * @param value The name of the devcenter.
     */
    @JvmName("tqmhoopytluguthx")
    public suspend fun devCenterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.devCenterName = mapped
    }

    /**
     * @param value The name of the Environment Definition.
     */
    @JvmName("rwjlvrfpaaquqhbt")
    public suspend fun environmentDefinitionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentDefinitionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fxkwjjlcdnipuupf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetEnvironmentDefinitionErrorDetailsPlainArgs =
        GetEnvironmentDefinitionErrorDetailsPlainArgs(
            catalogName = catalogName ?: throw PulumiNullFieldException("catalogName"),
            devCenterName = devCenterName ?: throw PulumiNullFieldException("devCenterName"),
            environmentDefinitionName = environmentDefinitionName ?: throw
                PulumiNullFieldException("environmentDefinitionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
