@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetNetworkConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkConnectionName Name of the Network Connection that can be applied to a Pool.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetNetworkConnectionPlainArgs(
    public val networkConnectionName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetNetworkConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetNetworkConnectionPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetNetworkConnectionPlainArgs.builder()
            .networkConnectionName(networkConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkConnectionPlainArgsBuilder internal constructor() {
    private var networkConnectionName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Network Connection that can be applied to a Pool.
     */
    @JvmName("bxsqwoqidavvucwf")
    public suspend fun networkConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkConnectionName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nxtcuxclqqygqllr")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkConnectionPlainArgs = GetNetworkConnectionPlainArgs(
        networkConnectionName = networkConnectionName ?: throw
            PulumiNullFieldException("networkConnectionName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
