@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetPoolPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property poolName Name of the pool.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetPoolPlainArgs(
    public val poolName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetPoolPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetPoolPlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetPoolPlainArgs.builder()
            .poolName(poolName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPoolPlainArgs].
 */
@PulumiTagMarker
public class GetPoolPlainArgsBuilder internal constructor() {
    private var poolName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the pool.
     */
    @JvmName("exhsnvtbdpbdpaqi")
    public suspend fun poolName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.poolName = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("almxtpphcgrcfmhx")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bnugvgeorpwjshcu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPoolPlainArgs = GetPoolPlainArgs(
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
