@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.GetProjectEnvironmentTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property environmentTypeName The name of the environment type.
 * @property projectName The name of the project.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetProjectEnvironmentTypePlainArgs(
    public val environmentTypeName: String,
    public val projectName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.GetProjectEnvironmentTypePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.GetProjectEnvironmentTypePlainArgs =
        com.pulumi.azurenative.devcenter.inputs.GetProjectEnvironmentTypePlainArgs.builder()
            .environmentTypeName(environmentTypeName.let({ args0 -> args0 }))
            .projectName(projectName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetProjectEnvironmentTypePlainArgs].
 */
@PulumiTagMarker
public class GetProjectEnvironmentTypePlainArgsBuilder internal constructor() {
    private var environmentTypeName: String? = null

    private var projectName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the environment type.
     */
    @JvmName("pdskhsupwvvuhuxy")
    public suspend fun environmentTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.environmentTypeName = mapped
    }

    /**
     * @param value The name of the project.
     */
    @JvmName("umfpdouquakthiej")
    public suspend fun projectName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.projectName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("nocshrbblkecwims")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetProjectEnvironmentTypePlainArgs = GetProjectEnvironmentTypePlainArgs(
        environmentTypeName = environmentTypeName ?: throw PulumiNullFieldException("environmentTypeName"),
        projectName = projectName ?: throw PulumiNullFieldException("projectName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
