@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.inputs

import com.pulumi.azurenative.devcenter.inputs.UserRoleAssignmentArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Mapping of user object ID to role assignments.
 * @property roles A map of roles to assign to the parent user.
 */
public data class UserRoleAssignmentArgs(
    public val roles: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devcenter.inputs.UserRoleAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.devcenter.inputs.UserRoleAssignmentArgs =
        com.pulumi.azurenative.devcenter.inputs.UserRoleAssignmentArgs.builder()
            .roles(roles?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [UserRoleAssignmentArgs].
 */
@PulumiTagMarker
public class UserRoleAssignmentArgsBuilder internal constructor() {
    private var roles: Output<List<String>>? = null

    /**
     * @param value A map of roles to assign to the parent user.
     */
    @JvmName("tifhxygcqegjcose")
    public suspend fun roles(`value`: Output<List<String>>) {
        this.roles = value
    }

    @JvmName("xqrykbvxpeakhnhc")
    public suspend fun roles(vararg values: Output<String>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values A map of roles to assign to the parent user.
     */
    @JvmName("ixoartjpuyutyyub")
    public suspend fun roles(values: List<Output<String>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value A map of roles to assign to the parent user.
     */
    @JvmName("rbnlqfnequaawqeh")
    public suspend fun roles(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param values A map of roles to assign to the parent user.
     */
    @JvmName("hasenavqvykvgmwl")
    public suspend fun roles(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    internal fun build(): UserRoleAssignmentArgs = UserRoleAssignmentArgs(
        roles = roles,
    )
}
