@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Network related settings
 * @property domainJoinType AAD Join type.
 * @property domainName Active Directory domain name
 * @property domainPassword The password for the account used to join domain
 * @property domainUsername The username of an Active Directory account (user or service account) that has permissions to create computer objects in Active Directory. Required format: admin@contoso.com.
 * @property healthCheckStatus Overall health status of the network connection. Health checks are run on creation, update, and periodically to validate the network connection.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property networkingResourceGroupName The name for resource group where NICs will be placed.
 * @property organizationUnit Active Directory domain Organization Unit (OU)
 * @property provisioningState The provisioning state of the resource.
 * @property subnetId The subnet to attach Virtual Machines to
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetNetworkConnectionResult(
    public val domainJoinType: String,
    public val domainName: String? = null,
    public val domainPassword: String? = null,
    public val domainUsername: String? = null,
    public val healthCheckStatus: String,
    public val id: String,
    public val location: String,
    public val name: String,
    public val networkingResourceGroupName: String? = null,
    public val organizationUnit: String? = null,
    public val provisioningState: String,
    public val subnetId: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GetNetworkConnectionResult):
            GetNetworkConnectionResult = GetNetworkConnectionResult(
            domainJoinType = javaType.domainJoinType(),
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            domainPassword = javaType.domainPassword().map({ args0 -> args0 }).orElse(null),
            domainUsername = javaType.domainUsername().map({ args0 -> args0 }).orElse(null),
            healthCheckStatus = javaType.healthCheckStatus(),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            networkingResourceGroupName = javaType.networkingResourceGroupName().map({ args0 ->
                args0
            }).orElse(null),
            organizationUnit = javaType.organizationUnit().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            subnetId = javaType.subnetId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.devcenter.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
