@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devcenter.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties for a Git repository catalog.
 * @property branch Git branch.
 * @property path The folder where the catalog items can be found inside the repository.
 * @property secretIdentifier A reference to the Key Vault secret containing a security token to authenticate to a Git repository.
 * @property uri Git URI.
 */
public data class GitCatalogResponse(
    public val branch: String? = null,
    public val path: String? = null,
    public val secretIdentifier: String? = null,
    public val uri: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devcenter.outputs.GitCatalogResponse):
            GitCatalogResponse = GitCatalogResponse(
            branch = javaType.branch().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            secretIdentifier = javaType.secretIdentifier().map({ args0 -> args0 }).orElse(null),
            uri = javaType.uri().map({ args0 -> args0 }).orElse(null),
        )
    }
}
