@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin

import com.pulumi.azurenative.devhub.kotlin.outputs.ACRResponse
import com.pulumi.azurenative.devhub.kotlin.outputs.DeploymentPropertiesResponse
import com.pulumi.azurenative.devhub.kotlin.outputs.GitHubWorkflowProfileResponseOidcCredentials
import com.pulumi.azurenative.devhub.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.devhub.kotlin.outputs.WorkflowRunResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.devhub.kotlin.outputs.ACRResponse.Companion.toKotlin as aCRResponseToKotlin
import com.pulumi.azurenative.devhub.kotlin.outputs.DeploymentPropertiesResponse.Companion.toKotlin as deploymentPropertiesResponseToKotlin
import com.pulumi.azurenative.devhub.kotlin.outputs.GitHubWorkflowProfileResponseOidcCredentials.Companion.toKotlin as gitHubWorkflowProfileResponseOidcCredentialsToKotlin
import com.pulumi.azurenative.devhub.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin
import com.pulumi.azurenative.devhub.kotlin.outputs.WorkflowRunResponse.Companion.toKotlin as workflowRunResponseToKotlin

/**
 * Builder for [Workflow].
 */
@PulumiTagMarker
public class WorkflowResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: WorkflowArgs = WorkflowArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend WorkflowArgsBuilder.() -> Unit) {
        val builder = WorkflowArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Workflow {
        val builtJavaResource = com.pulumi.azurenative.devhub.Workflow(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Workflow(builtJavaResource)
    }
}

/**
 * Resource representation of a workflow
 * Azure REST API version: 2022-10-11-preview. Prior API version in Azure Native 1.x: 2022-04-01-preview.
 * Other available API versions: 2023-08-01.
 * ## Example Usage
 * ### Create Workflow
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workflow = new AzureNative.DevHub.Workflow("workflow", new()
 *     {
 *         Acr = new AzureNative.DevHub.Inputs.ACRArgs
 *         {
 *             AcrRegistryName = "registry1",
 *             AcrRepositoryName = "repo1",
 *             AcrResourceGroup = "resourceGroup1",
 *             AcrSubscriptionId = "subscriptionId1",
 *         },
 *         AksResourceId = "/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1",
 *         BranchName = "branch1",
 *         DeploymentProperties = new AzureNative.DevHub.Inputs.DeploymentPropertiesArgs
 *         {
 *             KubeManifestLocations = new[]
 *             {
 *                 "/src/manifests/",
 *             },
 *             ManifestType = "kube",
 *             Overrides =
 *             {
 *                 { "key1", "value1" },
 *             },
 *         },
 *         DockerBuildContext = "repo1/src/",
 *         Dockerfile = "repo1/images/Dockerfile",
 *         Location = "location1",
 *         Namespace = "namespace1",
 *         OidcCredentials = new AzureNative.DevHub.Inputs.GitHubWorkflowProfileOidcCredentialsArgs
 *         {
 *             AzureClientId = "12345678-3456-7890-5678-012345678901",
 *             AzureTenantId = "66666666-3456-7890-5678-012345678901",
 *         },
 *         RepositoryName = "repo1",
 *         RepositoryOwner = "owner1",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "appname", "testApp" },
 *         },
 *         WorkflowName = "workflow1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devhub.NewWorkflow(ctx, "workflow", &devhub.WorkflowArgs{
 * 			Acr: &devhub.ACRArgs{
 * 				AcrRegistryName:   pulumi.String("registry1"),
 * 				AcrRepositoryName: pulumi.String("repo1"),
 * 				AcrResourceGroup:  pulumi.String("resourceGroup1"),
 * 				AcrSubscriptionId: pulumi.String("subscriptionId1"),
 * 			},
 * 			AksResourceId: pulumi.String("/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1"),
 * 			BranchName:    pulumi.String("branch1"),
 * 			DeploymentProperties: &devhub.DeploymentPropertiesArgs{
 * 				KubeManifestLocations: pulumi.StringArray{
 * 					pulumi.String("/src/manifests/"),
 * 				},
 * 				ManifestType: pulumi.String("kube"),
 * 				Overrides: pulumi.StringMap{
 * 					"key1": pulumi.String("value1"),
 * 				},
 * 			},
 * 			DockerBuildContext: pulumi.String("repo1/src/"),
 * 			Dockerfile:         pulumi.String("repo1/images/Dockerfile"),
 * 			Location:           pulumi.String("location1"),
 * 			Namespace:          pulumi.String("namespace1"),
 * 			OidcCredentials: &devhub.GitHubWorkflowProfileOidcCredentialsArgs{
 * 				AzureClientId: pulumi.String("12345678-3456-7890-5678-012345678901"),
 * 				AzureTenantId: pulumi.String("66666666-3456-7890-5678-012345678901"),
 * 			},
 * 			RepositoryName:    pulumi.String("repo1"),
 * 			RepositoryOwner:   pulumi.String("owner1"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"appname": pulumi.String("testApp"),
 * 			},
 * 			WorkflowName: pulumi.String("workflow1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devhub.Workflow;
 * import com.pulumi.azurenative.devhub.WorkflowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workflow = new Workflow("workflow", WorkflowArgs.builder()
 *             .acr(Map.ofEntries(
 *                 Map.entry("acrRegistryName", "registry1"),
 *                 Map.entry("acrRepositoryName", "repo1"),
 *                 Map.entry("acrResourceGroup", "resourceGroup1"),
 *                 Map.entry("acrSubscriptionId", "subscriptionId1")
 *             ))
 *             .aksResourceId("/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1")
 *             .branchName("branch1")
 *             .deploymentProperties(Map.ofEntries(
 *                 Map.entry("kubeManifestLocations", "/src/manifests/"),
 *                 Map.entry("manifestType", "kube"),
 *                 Map.entry("overrides", Map.of("key1", "value1"))
 *             ))
 *             .dockerBuildContext("repo1/src/")
 *             .dockerfile("repo1/images/Dockerfile")
 *             .location("location1")
 *             .namespace("namespace1")
 *             .oidcCredentials(Map.ofEntries(
 *                 Map.entry("azureClientId", "12345678-3456-7890-5678-012345678901"),
 *                 Map.entry("azureTenantId", "66666666-3456-7890-5678-012345678901")
 *             ))
 *             .repositoryName("repo1")
 *             .repositoryOwner("owner1")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("appname", "testApp"))
 *             .workflowName("workflow1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Workflow With Artifact Generation
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var workflow = new AzureNative.DevHub.Workflow("workflow", new()
 *     {
 *         Acr = new AzureNative.DevHub.Inputs.ACRArgs
 *         {
 *             AcrRegistryName = "registry1",
 *             AcrRepositoryName = "repo1",
 *             AcrResourceGroup = "resourceGroup1",
 *             AcrSubscriptionId = "subscriptionId1",
 *         },
 *         AksResourceId = "/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1",
 *         AppName = "my-app",
 *         BranchName = "branch1",
 *         DeploymentProperties = new AzureNative.DevHub.Inputs.DeploymentPropertiesArgs
 *         {
 *             KubeManifestLocations = new[]
 *             {
 *                 "/src/manifests/",
 *             },
 *             ManifestType = "kube",
 *             Overrides =
 *             {
 *                 { "key1", "value1" },
 *             },
 *         },
 *         DockerBuildContext = "repo1/src/",
 *         Dockerfile = "repo1/images/Dockerfile",
 *         DockerfileGenerationMode = "enabled",
 *         DockerfileOutputDirectory = "./",
 *         GenerationLanguage = "javascript",
 *         ImageName = "myimage",
 *         ImageTag = "latest",
 *         LanguageVersion = "14",
 *         Location = "location1",
 *         ManifestGenerationMode = "enabled",
 *         ManifestOutputDirectory = "./",
 *         ManifestType = "kube",
 *         OidcCredentials = new AzureNative.DevHub.Inputs.GitHubWorkflowProfileOidcCredentialsArgs
 *         {
 *             AzureClientId = "12345678-3456-7890-5678-012345678901",
 *             AzureTenantId = "66666666-3456-7890-5678-012345678901",
 *         },
 *         Port = "80",
 *         RepositoryName = "repo1",
 *         RepositoryOwner = "owner1",
 *         ResourceGroupName = "resourceGroup1",
 *         Tags =
 *         {
 *             { "appname", "testApp" },
 *         },
 *         WorkflowName = "workflow1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devhub/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devhub.NewWorkflow(ctx, "workflow", &devhub.WorkflowArgs{
 * 			Acr: &devhub.ACRArgs{
 * 				AcrRegistryName:   pulumi.String("registry1"),
 * 				AcrRepositoryName: pulumi.String("repo1"),
 * 				AcrResourceGroup:  pulumi.String("resourceGroup1"),
 * 				AcrSubscriptionId: pulumi.String("subscriptionId1"),
 * 			},
 * 			AksResourceId: pulumi.String("/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1"),
 * 			AppName:       pulumi.String("my-app"),
 * 			BranchName:    pulumi.String("branch1"),
 * 			DeploymentProperties: &devhub.DeploymentPropertiesArgs{
 * 				KubeManifestLocations: pulumi.StringArray{
 * 					pulumi.String("/src/manifests/"),
 * 				},
 * 				ManifestType: pulumi.String("kube"),
 * 				Overrides: pulumi.StringMap{
 * 					"key1": pulumi.String("value1"),
 * 				},
 * 			},
 * 			DockerBuildContext:        pulumi.String("repo1/src/"),
 * 			Dockerfile:                pulumi.String("repo1/images/Dockerfile"),
 * 			DockerfileGenerationMode:  pulumi.String("enabled"),
 * 			DockerfileOutputDirectory: pulumi.String("./"),
 * 			GenerationLanguage:        pulumi.String("javascript"),
 * 			ImageName:                 pulumi.String("myimage"),
 * 			ImageTag:                  pulumi.String("latest"),
 * 			LanguageVersion:           pulumi.String("14"),
 * 			Location:                  pulumi.String("location1"),
 * 			ManifestGenerationMode:    pulumi.String("enabled"),
 * 			ManifestOutputDirectory:   pulumi.String("./"),
 * 			ManifestType:              pulumi.String("kube"),
 * 			OidcCredentials: &devhub.GitHubWorkflowProfileOidcCredentialsArgs{
 * 				AzureClientId: pulumi.String("12345678-3456-7890-5678-012345678901"),
 * 				AzureTenantId: pulumi.String("66666666-3456-7890-5678-012345678901"),
 * 			},
 * 			Port:              pulumi.String("80"),
 * 			RepositoryName:    pulumi.String("repo1"),
 * 			RepositoryOwner:   pulumi.String("owner1"),
 * 			ResourceGroupName: pulumi.String("resourceGroup1"),
 * 			Tags: pulumi.StringMap{
 * 				"appname": pulumi.String("testApp"),
 * 			},
 * 			WorkflowName: pulumi.String("workflow1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devhub.Workflow;
 * import com.pulumi.azurenative.devhub.WorkflowArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var workflow = new Workflow("workflow", WorkflowArgs.builder()
 *             .acr(Map.ofEntries(
 *                 Map.entry("acrRegistryName", "registry1"),
 *                 Map.entry("acrRepositoryName", "repo1"),
 *                 Map.entry("acrResourceGroup", "resourceGroup1"),
 *                 Map.entry("acrSubscriptionId", "subscriptionId1")
 *             ))
 *             .aksResourceId("/subscriptions/subscriptionId1/resourcegroups/resourceGroup1/providers/Microsoft.ContainerService/managedClusters/cluster1")
 *             .appName("my-app")
 *             .branchName("branch1")
 *             .deploymentProperties(Map.ofEntries(
 *                 Map.entry("kubeManifestLocations", "/src/manifests/"),
 *                 Map.entry("manifestType", "kube"),
 *                 Map.entry("overrides", Map.of("key1", "value1"))
 *             ))
 *             .dockerBuildContext("repo1/src/")
 *             .dockerfile("repo1/images/Dockerfile")
 *             .dockerfileGenerationMode("enabled")
 *             .dockerfileOutputDirectory("./")
 *             .generationLanguage("javascript")
 *             .imageName("myimage")
 *             .imageTag("latest")
 *             .languageVersion("14")
 *             .location("location1")
 *             .manifestGenerationMode("enabled")
 *             .manifestOutputDirectory("./")
 *             .manifestType("kube")
 *             .oidcCredentials(Map.ofEntries(
 *                 Map.entry("azureClientId", "12345678-3456-7890-5678-012345678901"),
 *                 Map.entry("azureTenantId", "66666666-3456-7890-5678-012345678901")
 *             ))
 *             .port("80")
 *             .repositoryName("repo1")
 *             .repositoryOwner("owner1")
 *             .resourceGroupName("resourceGroup1")
 *             .tags(Map.of("appname", "testApp"))
 *             .workflowName("workflow1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devhub:Workflow workflow1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DevHub/workflows/{workflowName}
 * ```
 */
public class Workflow internal constructor(
    override val javaResource: com.pulumi.azurenative.devhub.Workflow,
) : KotlinCustomResource(javaResource, WorkflowMapper) {
    /**
     * Information on the azure container registry
     */
    public val acr: Output<ACRResponse>?
        get() = javaResource.acr().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    aCRResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Azure Kubernetes Cluster Resource the application will be deployed to.
     */
    public val aksResourceId: Output<String>?
        get() = javaResource.aksResourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the app.
     */
    public val appName: Output<String>?
        get() = javaResource.appName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Determines the authorization status of requests.
     */
    public val authStatus: Output<String>
        get() = javaResource.authStatus().applyValue({ args0 -> args0 })

    /**
     * Repository Branch Name
     */
    public val branchName: Output<String>?
        get() = javaResource.branchName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the language image used for building the code in the generated dockerfile.
     */
    public val builderVersion: Output<String>?
        get() = javaResource.builderVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val deploymentProperties: Output<DeploymentPropertiesResponse>?
        get() = javaResource.deploymentProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> deploymentPropertiesResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Path to Dockerfile Build Context within the repository.
     */
    public val dockerBuildContext: Output<String>?
        get() = javaResource.dockerBuildContext().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Path to the Dockerfile within the repository.
     */
    public val dockerfile: Output<String>?
        get() = javaResource.dockerfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The mode of generation to be used for generating Dockerfiles.
     */
    public val dockerfileGenerationMode: Output<String>?
        get() = javaResource.dockerfileGenerationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The directory to output the generated Dockerfile to.
     */
    public val dockerfileOutputDirectory: Output<String>?
        get() = javaResource.dockerfileOutputDirectory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The programming language used.
     */
    public val generationLanguage: Output<String>?
        get() = javaResource.generationLanguage().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the image to be generated.
     */
    public val imageName: Output<String>?
        get() = javaResource.imageName().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The tag to apply to the generated image.
     */
    public val imageTag: Output<String>?
        get() = javaResource.imageTag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The version of the language image used for execution in the generated dockerfile.
     */
    public val languageVersion: Output<String>?
        get() = javaResource.languageVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    public val lastWorkflowRun: Output<WorkflowRunResponse>?
        get() = javaResource.lastWorkflowRun().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> workflowRunResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The mode of generation to be used for generating Manifest.
     */
    public val manifestGenerationMode: Output<String>?
        get() = javaResource.manifestGenerationMode().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The directory to output the generated manifests to.
     */
    public val manifestOutputDirectory: Output<String>?
        get() = javaResource.manifestOutputDirectory().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Determines the type of manifests to be generated.
     */
    public val manifestType: Output<String>?
        get() = javaResource.manifestType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Kubernetes namespace the application is deployed to.
     */
    public val namespace: Output<String>?
        get() = javaResource.namespace().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The fields needed for OIDC with GitHub.
     */
    public val oidcCredentials: Output<GitHubWorkflowProfileResponseOidcCredentials>?
        get() = javaResource.oidcCredentials().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    gitHubWorkflowProfileResponseOidcCredentialsToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The port the application is exposed on.
     */
    public val port: Output<String>?
        get() = javaResource.port().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The status of the Pull Request submitted against the users repository.
     */
    public val prStatus: Output<String>
        get() = javaResource.prStatus().applyValue({ args0 -> args0 })

    /**
     * The URL to the Pull Request submitted against the users repository.
     */
    public val prURL: Output<String>
        get() = javaResource.prURL().applyValue({ args0 -> args0 })

    /**
     * The number associated with the submitted pull request.
     */
    public val pullNumber: Output<Int>
        get() = javaResource.pullNumber().applyValue({ args0 -> args0 })

    /**
     * Repository Name
     */
    public val repositoryName: Output<String>?
        get() = javaResource.repositoryName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Repository Owner
     */
    public val repositoryOwner: Output<String>?
        get() = javaResource.repositoryOwner().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object WorkflowMapper : ResourceMapper<Workflow> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devhub.Workflow::class == javaResource::class

    override fun map(javaResource: Resource): Workflow = Workflow(
        javaResource as
            com.pulumi.azurenative.devhub.Workflow,
    )
}

/**
 * @see [Workflow].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Workflow].
 */
public suspend fun workflow(name: String, block: suspend WorkflowResourceBuilder.() -> Unit):
    Workflow {
    val builder = WorkflowResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Workflow].
 * @param name The _unique_ name of the resulting resource.
 */
public fun workflow(name: String): Workflow {
    val builder = WorkflowResourceBuilder()
    builder.name(name)
    return builder.build()
}
