@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The mode of generation to be used for generating Manifest.
 */
public enum class ManifestGenerationMode(
    public val javaValue: com.pulumi.azurenative.devhub.enums.ManifestGenerationMode,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.enums.ManifestGenerationMode> {
    /**
     * Manifests will be generated
     */
    Enabled(com.pulumi.azurenative.devhub.enums.ManifestGenerationMode.Enabled),

    /**
     * Manifests will not be generated
     */
    Disabled(com.pulumi.azurenative.devhub.enums.ManifestGenerationMode.Disabled),
    ;

    override fun toJava(): com.pulumi.azurenative.devhub.enums.ManifestGenerationMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.enums.ManifestGenerationMode):
            ManifestGenerationMode = ManifestGenerationMode.values().first { it.javaValue == javaType }
    }
}
