@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Describes the status of the workflow run
 */
public enum class WorkflowRunStatus(
    public val javaValue: com.pulumi.azurenative.devhub.enums.WorkflowRunStatus,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.enums.WorkflowRunStatus> {
    /**
     * Workflow run is queued
     */
    Queued(com.pulumi.azurenative.devhub.enums.WorkflowRunStatus.Queued),

    /**
     * Workflow run is inprogress
     */
    Inprogress(com.pulumi.azurenative.devhub.enums.WorkflowRunStatus.Inprogress),

    /**
     * Workflow run is completed
     */
    Completed(com.pulumi.azurenative.devhub.enums.WorkflowRunStatus.Completed),
    ;

    override fun toJava(): com.pulumi.azurenative.devhub.enums.WorkflowRunStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devhub.enums.WorkflowRunStatus):
            WorkflowRunStatus = WorkflowRunStatus.values().first { it.javaValue == javaType }
    }
}
