@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.ACRArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Information on the azure container registry
 * @property acrRegistryName ACR registry
 * @property acrRepositoryName ACR repository
 * @property acrResourceGroup ACR resource group
 * @property acrSubscriptionId ACR subscription id
 */
public data class ACRArgs(
    public val acrRegistryName: Output<String>? = null,
    public val acrRepositoryName: Output<String>? = null,
    public val acrResourceGroup: Output<String>? = null,
    public val acrSubscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.ACRArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.ACRArgs =
        com.pulumi.azurenative.devhub.inputs.ACRArgs.builder()
            .acrRegistryName(acrRegistryName?.applyValue({ args0 -> args0 }))
            .acrRepositoryName(acrRepositoryName?.applyValue({ args0 -> args0 }))
            .acrResourceGroup(acrResourceGroup?.applyValue({ args0 -> args0 }))
            .acrSubscriptionId(acrSubscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ACRArgs].
 */
@PulumiTagMarker
public class ACRArgsBuilder internal constructor() {
    private var acrRegistryName: Output<String>? = null

    private var acrRepositoryName: Output<String>? = null

    private var acrResourceGroup: Output<String>? = null

    private var acrSubscriptionId: Output<String>? = null

    /**
     * @param value ACR registry
     */
    @JvmName("pqctgjrdvlackqct")
    public suspend fun acrRegistryName(`value`: Output<String>) {
        this.acrRegistryName = value
    }

    /**
     * @param value ACR repository
     */
    @JvmName("obiknqqjsjdljtwt")
    public suspend fun acrRepositoryName(`value`: Output<String>) {
        this.acrRepositoryName = value
    }

    /**
     * @param value ACR resource group
     */
    @JvmName("sibeyehllvwprbmj")
    public suspend fun acrResourceGroup(`value`: Output<String>) {
        this.acrResourceGroup = value
    }

    /**
     * @param value ACR subscription id
     */
    @JvmName("mmlyiejiniagfsoc")
    public suspend fun acrSubscriptionId(`value`: Output<String>) {
        this.acrSubscriptionId = value
    }

    /**
     * @param value ACR registry
     */
    @JvmName("xnqieadqyrlvlyjh")
    public suspend fun acrRegistryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrRegistryName = mapped
    }

    /**
     * @param value ACR repository
     */
    @JvmName("oroogfxokkjeqduy")
    public suspend fun acrRepositoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrRepositoryName = mapped
    }

    /**
     * @param value ACR resource group
     */
    @JvmName("oyylecmlepoqfeaw")
    public suspend fun acrResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrResourceGroup = mapped
    }

    /**
     * @param value ACR subscription id
     */
    @JvmName("gwapthksqgtfhrsu")
    public suspend fun acrSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrSubscriptionId = mapped
    }

    internal fun build(): ACRArgs = ACRArgs(
        acrRegistryName = acrRegistryName,
        acrRepositoryName = acrRepositoryName,
        acrResourceGroup = acrResourceGroup,
        acrSubscriptionId = acrSubscriptionId,
    )
}
