@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.GitHubWorkflowProfileOidcCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The fields needed for OIDC with GitHub.
 * @property azureClientId Azure Application Client ID
 * @property azureTenantId Azure Directory (tenant) ID
 */
public data class GitHubWorkflowProfileOidcCredentialsArgs(
    public val azureClientId: Output<String>? = null,
    public val azureTenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.GitHubWorkflowProfileOidcCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.devhub.inputs.GitHubWorkflowProfileOidcCredentialsArgs =
        com.pulumi.azurenative.devhub.inputs.GitHubWorkflowProfileOidcCredentialsArgs.builder()
            .azureClientId(azureClientId?.applyValue({ args0 -> args0 }))
            .azureTenantId(azureTenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GitHubWorkflowProfileOidcCredentialsArgs].
 */
@PulumiTagMarker
public class GitHubWorkflowProfileOidcCredentialsArgsBuilder internal constructor() {
    private var azureClientId: Output<String>? = null

    private var azureTenantId: Output<String>? = null

    /**
     * @param value Azure Application Client ID
     */
    @JvmName("dgvhtyplqrsuutjc")
    public suspend fun azureClientId(`value`: Output<String>) {
        this.azureClientId = value
    }

    /**
     * @param value Azure Directory (tenant) ID
     */
    @JvmName("jvkbkwmculjqnpem")
    public suspend fun azureTenantId(`value`: Output<String>) {
        this.azureTenantId = value
    }

    /**
     * @param value Azure Application Client ID
     */
    @JvmName("qvjjuimyavclciwi")
    public suspend fun azureClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureClientId = mapped
    }

    /**
     * @param value Azure Directory (tenant) ID
     */
    @JvmName("oslpfoclovycslla")
    public suspend fun azureTenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureTenantId = mapped
    }

    internal fun build(): GitHubWorkflowProfileOidcCredentialsArgs =
        GitHubWorkflowProfileOidcCredentialsArgs(
            azureClientId = azureClientId,
            azureTenantId = azureTenantId,
        )
}
