@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devhub.kotlin.inputs

import com.pulumi.azurenative.devhub.inputs.WorkflowRunArgs.builder
import com.pulumi.azurenative.devhub.kotlin.enums.WorkflowRunStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property workflowRunStatus Describes the status of the workflow run
 */
public data class WorkflowRunArgs(
    public val workflowRunStatus: Output<Either<String, WorkflowRunStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devhub.inputs.WorkflowRunArgs> {
    override fun toJava(): com.pulumi.azurenative.devhub.inputs.WorkflowRunArgs =
        com.pulumi.azurenative.devhub.inputs.WorkflowRunArgs.builder()
            .workflowRunStatus(
                workflowRunStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [WorkflowRunArgs].
 */
@PulumiTagMarker
public class WorkflowRunArgsBuilder internal constructor() {
    private var workflowRunStatus: Output<Either<String, WorkflowRunStatus>>? = null

    /**
     * @param value Describes the status of the workflow run
     */
    @JvmName("xbtuvrtuxeugimcs")
    public suspend fun workflowRunStatus(`value`: Output<Either<String, WorkflowRunStatus>>) {
        this.workflowRunStatus = value
    }

    /**
     * @param value Describes the status of the workflow run
     */
    @JvmName("tbbujlhisbaqsesi")
    public suspend fun workflowRunStatus(`value`: Either<String, WorkflowRunStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workflowRunStatus = mapped
    }

    /**
     * @param value Describes the status of the workflow run
     */
    @JvmName("munqojskkmkvlalu")
    public fun workflowRunStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, WorkflowRunStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflowRunStatus = mapped
    }

    /**
     * @param value Describes the status of the workflow run
     */
    @JvmName("gapwqggkdjbbhslj")
    public fun workflowRunStatus(`value`: WorkflowRunStatus) {
        val toBeMapped = Either.ofRight<String, WorkflowRunStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workflowRunStatus = mapped
    }

    internal fun build(): WorkflowRunArgs = WorkflowRunArgs(
        workflowRunStatus = workflowRunStatus,
    )
}
