@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin

import com.pulumi.azurenative.deviceregistry.AssetArgs.builder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.AssetExtendedLocationArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.AssetExtendedLocationArgsBuilder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.AssetPropertiesArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.AssetPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Asset definition.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### Create an Asset With External Asset Id
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetName = "my-asset",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.AssetExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         Properties = new AzureNative.DeviceRegistry.Inputs.AssetPropertiesArgs
 *         {
 *             AssetEndpointProfileUri = "https://www.example.com/myConnectivityProfile",
 *             AssetType = "MyAssetType",
 *             DataPoints = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                     ObservabilityMode = "counter",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                     ObservabilityMode = "none",
 *                 },
 *             },
 *             DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             Description = "This is a sample Asset",
 *             DisplayName = "AssetDisplayName",
 *             DocumentationUri = "https://www.example.com/manual",
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                     ObservabilityMode = "none",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                     ObservabilityMode = "log",
 *                 },
 *             },
 *             ExternalAssetId = "8ZBA6LRHU0A458969",
 *             HardwareRevision = "1.0",
 *             Manufacturer = "Contoso",
 *             ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *             Model = "ContosoModel",
 *             ProductCode = "SA34VDG",
 *             SerialNumber = "64-103816-519918-8",
 *             SoftwareRevision = "2.0",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetName: pulumi.String("my-asset"),
 * 			ExtendedLocation: &deviceregistry.AssetExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("West Europe"),
 * 			Properties: deviceregistry.AssetResponseProperties{
 * 				AssetEndpointProfileUri: pulumi.String("https://www.example.com/myConnectivityProfile"),
 * 				AssetType:               pulumi.String("MyAssetType"),
 * 				DataPoints: deviceregistry.AssetPropertiesDataPointsArray{
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 						ObservabilityMode:      pulumi.String("counter"),
 * 					},
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 						ObservabilityMode:      pulumi.String("none"),
 * 					},
 * 				},
 * 				DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				Description:                    pulumi.String("This is a sample Asset"),
 * 				DisplayName:                    pulumi.String("AssetDisplayName"),
 * 				DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 				Enabled:                        pulumi.Bool(true),
 * 				Events: deviceregistry.AssetPropertiesEventsArray{
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 						ObservabilityMode:  pulumi.String("none"),
 * 					},
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 						ObservabilityMode:  pulumi.String("log"),
 * 					},
 * 				},
 * 				ExternalAssetId:  pulumi.String("8ZBA6LRHU0A458969"),
 * 				HardwareRevision: pulumi.String("1.0"),
 * 				Manufacturer:     pulumi.String("Contoso"),
 * 				ManufacturerUri:  pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 				Model:            pulumi.String("ContosoModel"),
 * 				ProductCode:      pulumi.String("SA34VDG"),
 * 				SerialNumber:     pulumi.String("64-103816-519918-8"),
 * 				SoftwareRevision: pulumi.String("2.0"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetName("my-asset")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West Europe")
 *             .properties(Map.ofEntries(
 *                 Map.entry("assetEndpointProfileUri", "https://www.example.com/myConnectivityProfile"),
 *                 Map.entry("assetType", "MyAssetType"),
 *                 Map.entry("dataPoints",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 *                         Map.entry("observabilityMode", "counter")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 *                         Map.entry("observabilityMode", "none")
 *                     )),
 *                 Map.entry("defaultDataPointsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("defaultEventsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("description", "This is a sample Asset"),
 *                 Map.entry("displayName", "AssetDisplayName"),
 *                 Map.entry("documentationUri", "https://www.example.com/manual"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("events",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 *                         Map.entry("observabilityMode", "none")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 *                         Map.entry("observabilityMode", "log")
 *                     )),
 *                 Map.entry("externalAssetId", "8ZBA6LRHU0A458969"),
 *                 Map.entry("hardwareRevision", "1.0"),
 *                 Map.entry("manufacturer", "Contoso"),
 *                 Map.entry("manufacturerUri", "https://www.contoso.com/manufacturerUri"),
 *                 Map.entry("model", "ContosoModel"),
 *                 Map.entry("productCode", "SA34VDG"),
 *                 Map.entry("serialNumber", "64-103816-519918-8"),
 *                 Map.entry("softwareRevision", "2.0")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset Without Display Name
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetName = "my-asset",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.AssetExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         Properties = new AzureNative.DeviceRegistry.Inputs.AssetPropertiesArgs
 *         {
 *             AssetEndpointProfileUri = "https://www.example.com/myConnectivityProfile",
 *             AssetType = "MyAssetType",
 *             DataPoints = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                     ObservabilityMode = "counter",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                     ObservabilityMode = "none",
 *                 },
 *             },
 *             DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             Description = "This is a sample Asset",
 *             DocumentationUri = "https://www.example.com/manual",
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                     ObservabilityMode = "none",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                     ObservabilityMode = "log",
 *                 },
 *             },
 *             ExternalAssetId = "8ZBA6LRHU0A458969",
 *             HardwareRevision = "1.0",
 *             Manufacturer = "Contoso",
 *             ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *             Model = "ContosoModel",
 *             ProductCode = "SA34VDG",
 *             SerialNumber = "64-103816-519918-8",
 *             SoftwareRevision = "2.0",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetName: pulumi.String("my-asset"),
 * 			ExtendedLocation: &deviceregistry.AssetExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("West Europe"),
 * 			Properties: deviceregistry.AssetResponseProperties{
 * 				AssetEndpointProfileUri: pulumi.String("https://www.example.com/myConnectivityProfile"),
 * 				AssetType:               pulumi.String("MyAssetType"),
 * 				DataPoints: deviceregistry.AssetPropertiesDataPointsArray{
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 						ObservabilityMode:      pulumi.String("counter"),
 * 					},
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 						ObservabilityMode:      pulumi.String("none"),
 * 					},
 * 				},
 * 				DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				Description:                    pulumi.String("This is a sample Asset"),
 * 				DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 				Enabled:                        pulumi.Bool(true),
 * 				Events: deviceregistry.AssetPropertiesEventsArray{
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 						ObservabilityMode:  pulumi.String("none"),
 * 					},
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 						ObservabilityMode:  pulumi.String("log"),
 * 					},
 * 				},
 * 				ExternalAssetId:  pulumi.String("8ZBA6LRHU0A458969"),
 * 				HardwareRevision: pulumi.String("1.0"),
 * 				Manufacturer:     pulumi.String("Contoso"),
 * 				ManufacturerUri:  pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 				Model:            pulumi.String("ContosoModel"),
 * 				ProductCode:      pulumi.String("SA34VDG"),
 * 				SerialNumber:     pulumi.String("64-103816-519918-8"),
 * 				SoftwareRevision: pulumi.String("2.0"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetName("my-asset")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West Europe")
 *             .properties(Map.ofEntries(
 *                 Map.entry("assetEndpointProfileUri", "https://www.example.com/myConnectivityProfile"),
 *                 Map.entry("assetType", "MyAssetType"),
 *                 Map.entry("dataPoints",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 *                         Map.entry("observabilityMode", "counter")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 *                         Map.entry("observabilityMode", "none")
 *                     )),
 *                 Map.entry("defaultDataPointsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("defaultEventsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("description", "This is a sample Asset"),
 *                 Map.entry("documentationUri", "https://www.example.com/manual"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("events",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 *                         Map.entry("observabilityMode", "none")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 *                         Map.entry("observabilityMode", "log")
 *                     )),
 *                 Map.entry("externalAssetId", "8ZBA6LRHU0A458969"),
 *                 Map.entry("hardwareRevision", "1.0"),
 *                 Map.entry("manufacturer", "Contoso"),
 *                 Map.entry("manufacturerUri", "https://www.contoso.com/manufacturerUri"),
 *                 Map.entry("model", "ContosoModel"),
 *                 Map.entry("productCode", "SA34VDG"),
 *                 Map.entry("serialNumber", "64-103816-519918-8"),
 *                 Map.entry("softwareRevision", "2.0")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create an Asset Without External Asset Id
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var asset = new AzureNative.DeviceRegistry.Asset("asset", new()
 *     {
 *         AssetName = "my-asset",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.AssetExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         Properties = new AzureNative.DeviceRegistry.Inputs.AssetPropertiesArgs
 *         {
 *             AssetEndpointProfileUri = "https://www.example.com/myConnectivityProfile",
 *             AssetType = "MyAssetType",
 *             DataPoints = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1",
 *                     ObservabilityMode = "counter",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesDataPointsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     DataPointConfiguration = "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}",
 *                     DataSource = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2",
 *                     ObservabilityMode = "none",
 *                 },
 *             },
 *             DefaultDataPointsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             DefaultEventsConfiguration = "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}",
 *             Description = "This is a sample Asset",
 *             DisplayName = "AssetDisplayName",
 *             DocumentationUri = "https://www.example.com/manual",
 *             Enabled = true,
 *             Events = new[]
 *             {
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__temperature;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3",
 *                     ObservabilityMode = "none",
 *                 },
 *                 new AzureNative.DeviceRegistry.Inputs.AssetPropertiesEventsArgs
 *                 {
 *                     CapabilityId = "dtmi:com:example:Thermostat:__pressure;1",
 *                     EventConfiguration = "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}",
 *                     EventNotifier = "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4",
 *                     ObservabilityMode = "log",
 *                 },
 *             },
 *             HardwareRevision = "1.0",
 *             Manufacturer = "Contoso",
 *             ManufacturerUri = "https://www.contoso.com/manufacturerUri",
 *             Model = "ContosoModel",
 *             ProductCode = "SA34VDG",
 *             SerialNumber = "64-103816-519918-8",
 *             SoftwareRevision = "2.0",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAsset(ctx, "asset", &deviceregistry.AssetArgs{
 * 			AssetName: pulumi.String("my-asset"),
 * 			ExtendedLocation: &deviceregistry.AssetExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("West Europe"),
 * 			Properties: deviceregistry.AssetResponseProperties{
 * 				AssetEndpointProfileUri: pulumi.String("https://www.example.com/myConnectivityProfile"),
 * 				AssetType:               pulumi.String("MyAssetType"),
 * 				DataPoints: deviceregistry.AssetPropertiesDataPointsArray{
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 * 						ObservabilityMode:      pulumi.String("counter"),
 * 					},
 * 					&deviceregistry.AssetPropertiesDataPointsArgs{
 * 						CapabilityId:           pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						DataPointConfiguration: pulumi.String("{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 * 						DataSource:             pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 * 						ObservabilityMode:      pulumi.String("none"),
 * 					},
 * 				},
 * 				DefaultDataPointsConfiguration: pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				DefaultEventsConfiguration:     pulumi.String("{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 * 				Description:                    pulumi.String("This is a sample Asset"),
 * 				DisplayName:                    pulumi.String("AssetDisplayName"),
 * 				DocumentationUri:               pulumi.String("https://www.example.com/manual"),
 * 				Enabled:                        pulumi.Bool(true),
 * 				Events: deviceregistry.AssetPropertiesEventsArray{
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__temperature;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 * 						ObservabilityMode:  pulumi.String("none"),
 * 					},
 * 					&deviceregistry.AssetPropertiesEventsArgs{
 * 						CapabilityId:       pulumi.String("dtmi:com:example:Thermostat:__pressure;1"),
 * 						EventConfiguration: pulumi.String("{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 * 						EventNotifier:      pulumi.String("nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 * 						ObservabilityMode:  pulumi.String("log"),
 * 					},
 * 				},
 * 				HardwareRevision: pulumi.String("1.0"),
 * 				Manufacturer:     pulumi.String("Contoso"),
 * 				ManufacturerUri:  pulumi.String("https://www.contoso.com/manufacturerUri"),
 * 				Model:            pulumi.String("ContosoModel"),
 * 				ProductCode:      pulumi.String("SA34VDG"),
 * 				SerialNumber:     pulumi.String("64-103816-519918-8"),
 * 				SoftwareRevision: pulumi.String("2.0"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.Asset;
 * import com.pulumi.azurenative.deviceregistry.AssetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var asset = new Asset("asset", AssetArgs.builder()
 *             .assetName("my-asset")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West Europe")
 *             .properties(Map.ofEntries(
 *                 Map.entry("assetEndpointProfileUri", "https://www.example.com/myConnectivityProfile"),
 *                 Map.entry("assetType", "MyAssetType"),
 *                 Map.entry("dataPoints",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":8,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt1"),
 *                         Map.entry("observabilityMode", "counter")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("dataPointConfiguration", "{\"publishingInterval\":4,\"samplingInterval\":4,\"queueSize\":7}"),
 *                         Map.entry("dataSource", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt2"),
 *                         Map.entry("observabilityMode", "none")
 *                     )),
 *                 Map.entry("defaultDataPointsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("defaultEventsConfiguration", "{\"publishingInterval\":10,\"samplingInterval\":15,\"queueSize\":20}"),
 *                 Map.entry("description", "This is a sample Asset"),
 *                 Map.entry("displayName", "AssetDisplayName"),
 *                 Map.entry("documentationUri", "https://www.example.com/manual"),
 *                 Map.entry("enabled", true),
 *                 Map.entry("events",
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__temperature;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":1,\"queueSize\":8}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt3"),
 *                         Map.entry("observabilityMode", "none")
 *                     ),
 *                     Map.ofEntries(
 *                         Map.entry("capabilityId", "dtmi:com:example:Thermostat:__pressure;1"),
 *                         Map.entry("eventConfiguration", "{\"publishingInterval\":7,\"samplingInterval\":8,\"queueSize\":4}"),
 *                         Map.entry("eventNotifier", "nsu=http://microsoft.com/Opc/OpcPlc/;s=FastUInt4"),
 *                         Map.entry("observabilityMode", "log")
 *                     )),
 *                 Map.entry("hardwareRevision", "1.0"),
 *                 Map.entry("manufacturer", "Contoso"),
 *                 Map.entry("manufacturerUri", "https://www.contoso.com/manufacturerUri"),
 *                 Map.entry("model", "ContosoModel"),
 *                 Map.entry("productCode", "SA34VDG"),
 *                 Map.entry("serialNumber", "64-103816-519918-8"),
 *                 Map.entry("softwareRevision", "2.0")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceregistry:Asset my-asset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assets/{assetName}
 * ```
 * @property assetName Asset name parameter.
 * @property extendedLocation The extended location.
 * @property location The geo-location where the resource lives
 * @property properties Asset resource properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AssetArgs(
    public val assetName: Output<String>? = null,
    public val extendedLocation: Output<AssetExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<AssetPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.AssetArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.AssetArgs =
        com.pulumi.azurenative.deviceregistry.AssetArgs.builder()
            .assetName(assetName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AssetArgs].
 */
@PulumiTagMarker
public class AssetArgsBuilder internal constructor() {
    private var assetName: Output<String>? = null

    private var extendedLocation: Output<AssetExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<AssetPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Asset name parameter.
     */
    @JvmName("esbbcvvijwjdtqrn")
    public suspend fun assetName(`value`: Output<String>) {
        this.assetName = value
    }

    /**
     * @param value The extended location.
     */
    @JvmName("qqmcvsuucpgmrpvu")
    public suspend fun extendedLocation(`value`: Output<AssetExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pljaanfralvacaid")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Asset resource properties.
     */
    @JvmName("wfvtfubrebtludfn")
    public suspend fun properties(`value`: Output<AssetPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("unoheswbsfwvslox")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kxhernthmnqpjjhi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Asset name parameter.
     */
    @JvmName("dbxiumcvxhttbyvr")
    public suspend fun assetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetName = mapped
    }

    /**
     * @param value The extended location.
     */
    @JvmName("adlwmrxpalkvvmgt")
    public suspend fun extendedLocation(`value`: AssetExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location.
     */
    @JvmName("kutvbhqdpjcodyvf")
    public suspend
    fun extendedLocation(argument: suspend AssetExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = AssetExtendedLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("lrkpakwrbntrdeap")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Asset resource properties.
     */
    @JvmName("iounqcmrxhofncpf")
    public suspend fun properties(`value`: AssetPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Asset resource properties.
     */
    @JvmName("uoukegvwmfvnbbjo")
    public suspend fun properties(argument: suspend AssetPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AssetPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xyumdynlmxgxacpp")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mnucasfrnrhowcik")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("tjrdjwhpltayjbcj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AssetArgs = AssetArgs(
        assetName = assetName,
        extendedLocation = extendedLocation,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
