@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin

import com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs.builder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.AssetEndpointProfileExtendedLocationArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.AssetEndpointProfileExtendedLocationArgsBuilder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.AssetEndpointProfilePropertiesArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.AssetEndpointProfilePropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Asset Endpoint Profile definition.
 * Azure REST API version: 2023-11-01-preview.
 * ## Example Usage
 * ### Create an Asset Endpoint Profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var assetEndpointProfile = new AzureNative.DeviceRegistry.AssetEndpointProfile("assetEndpointProfile", new()
 *     {
 *         AssetEndpointProfileName = "my-assetendpointprofile",
 *         ExtendedLocation = new AzureNative.DeviceRegistry.Inputs.AssetEndpointProfileExtendedLocationArgs
 *         {
 *             Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1",
 *             Type = "CustomLocation",
 *         },
 *         Location = "West Europe",
 *         Properties = new AzureNative.DeviceRegistry.Inputs.AssetEndpointProfilePropertiesArgs
 *         {
 *             TargetAddress = "https://www.example.com/myTargetAddress",
 *             UserAuthentication = new AzureNative.DeviceRegistry.Inputs.AssetEndpointProfilePropertiesUserAuthenticationArgs
 *             {
 *                 Mode = "Anonymous",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         Tags =
 *         {
 *             { "site", "building-1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deviceregistry/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deviceregistry.NewAssetEndpointProfile(ctx, "assetEndpointProfile", &deviceregistry.AssetEndpointProfileArgs{
 * 			AssetEndpointProfileName: pulumi.String("my-assetendpointprofile"),
 * 			ExtendedLocation: &deviceregistry.AssetEndpointProfileExtendedLocationArgs{
 * 				Name: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 * 				Type: pulumi.String("CustomLocation"),
 * 			},
 * 			Location: pulumi.String("West Europe"),
 * 			Properties: deviceregistry.AssetEndpointProfilePropertiesResponse{
 * 				TargetAddress: pulumi.String("https://www.example.com/myTargetAddress"),
 * 				UserAuthentication: &deviceregistry.AssetEndpointProfilePropertiesUserAuthenticationArgs{
 * 					Mode: pulumi.String("Anonymous"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			Tags: pulumi.StringMap{
 * 				"site": pulumi.String("building-1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deviceregistry.AssetEndpointProfile;
 * import com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var assetEndpointProfile = new AssetEndpointProfile("assetEndpointProfile", AssetEndpointProfileArgs.builder()
 *             .assetEndpointProfileName("my-assetendpointprofile")
 *             .extendedLocation(Map.ofEntries(
 *                 Map.entry("name", "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/location1"),
 *                 Map.entry("type", "CustomLocation")
 *             ))
 *             .location("West Europe")
 *             .properties(Map.ofEntries(
 *                 Map.entry("targetAddress", "https://www.example.com/myTargetAddress"),
 *                 Map.entry("userAuthentication", Map.of("mode", "Anonymous"))
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .tags(Map.of("site", "building-1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deviceregistry:AssetEndpointProfile my-assetendpointprofile /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeviceRegistry/assetEndpointProfiles/{assetEndpointProfileName}
 * ```
 * @property assetEndpointProfileName Asset Endpoint Profile name parameter.
 * @property extendedLocation The extended location.
 * @property location The geo-location where the resource lives
 * @property properties Asset Endpoint Profile resource properties.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 */
public data class AssetEndpointProfileArgs(
    public val assetEndpointProfileName: Output<String>? = null,
    public val extendedLocation: Output<AssetEndpointProfileExtendedLocationArgs>? = null,
    public val location: Output<String>? = null,
    public val properties: Output<AssetEndpointProfilePropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs =
        com.pulumi.azurenative.deviceregistry.AssetEndpointProfileArgs.builder()
            .assetEndpointProfileName(assetEndpointProfileName?.applyValue({ args0 -> args0 }))
            .extendedLocation(extendedLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [AssetEndpointProfileArgs].
 */
@PulumiTagMarker
public class AssetEndpointProfileArgsBuilder internal constructor() {
    private var assetEndpointProfileName: Output<String>? = null

    private var extendedLocation: Output<AssetEndpointProfileExtendedLocationArgs>? = null

    private var location: Output<String>? = null

    private var properties: Output<AssetEndpointProfilePropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Asset Endpoint Profile name parameter.
     */
    @JvmName("tqretgwbgaslosqr")
    public suspend fun assetEndpointProfileName(`value`: Output<String>) {
        this.assetEndpointProfileName = value
    }

    /**
     * @param value The extended location.
     */
    @JvmName("mnmkmcalipfvxoql")
    public suspend fun extendedLocation(`value`: Output<AssetEndpointProfileExtendedLocationArgs>) {
        this.extendedLocation = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rfyoeqfklpaqoacl")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Asset Endpoint Profile resource properties.
     */
    @JvmName("tothtdlvprdhgmwm")
    public suspend fun properties(`value`: Output<AssetEndpointProfilePropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rgjgbtgnibqrwwkm")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("icjvcaxpluibpqct")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Asset Endpoint Profile name parameter.
     */
    @JvmName("bejqdfiwkskcolvm")
    public suspend fun assetEndpointProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.assetEndpointProfileName = mapped
    }

    /**
     * @param value The extended location.
     */
    @JvmName("iwippfakdqqfnxrb")
    public suspend fun extendedLocation(`value`: AssetEndpointProfileExtendedLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedLocation = mapped
    }

    /**
     * @param argument The extended location.
     */
    @JvmName("pydgbpibgpaxonro")
    public suspend
    fun extendedLocation(argument: suspend AssetEndpointProfileExtendedLocationArgsBuilder.() -> Unit) {
        val toBeMapped = AssetEndpointProfileExtendedLocationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.extendedLocation = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vofdwarskaqaqadg")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Asset Endpoint Profile resource properties.
     */
    @JvmName("nceqplcgwmotddru")
    public suspend fun properties(`value`: AssetEndpointProfilePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Asset Endpoint Profile resource properties.
     */
    @JvmName("oyqwylcmucmchjeg")
    public suspend
    fun properties(argument: suspend AssetEndpointProfilePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = AssetEndpointProfilePropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("odhdvaebhfvachdo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("inpuemyptfujfavv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("qiqfvtgrlonogtgt")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): AssetEndpointProfileArgs = AssetEndpointProfileArgs(
        assetEndpointProfileName = assetEndpointProfileName,
        extendedLocation = extendedLocation,
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
