@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin

import com.pulumi.azurenative.deviceregistry.DeviceregistryFunctions.getAssetEndpointProfilePlain
import com.pulumi.azurenative.deviceregistry.DeviceregistryFunctions.getAssetPlain
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.GetAssetEndpointProfilePlainArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.GetAssetEndpointProfilePlainArgsBuilder
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.GetAssetPlainArgs
import com.pulumi.azurenative.deviceregistry.kotlin.inputs.GetAssetPlainArgsBuilder
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.GetAssetEndpointProfileResult
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.GetAssetResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.GetAssetEndpointProfileResult.Companion.toKotlin as getAssetEndpointProfileResultToKotlin
import com.pulumi.azurenative.deviceregistry.kotlin.outputs.GetAssetResult.Companion.toKotlin as getAssetResultToKotlin

public object DeviceregistryFunctions {
    /**
     * Retrieve a single asset.
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return Asset definition.
     */
    public suspend fun getAsset(argument: GetAssetPlainArgs): GetAssetResult =
        getAssetResultToKotlin(getAssetPlain(argument.toJava()).await())

    /**
     * @see [getAsset].
     * @param assetName Asset name parameter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Asset definition.
     */
    public suspend fun getAsset(assetName: String, resourceGroupName: String): GetAssetResult {
        val argument = GetAssetPlainArgs(
            assetName = assetName,
            resourceGroupName = resourceGroupName,
        )
        return getAssetResultToKotlin(getAssetPlain(argument.toJava()).await())
    }

    /**
     * @see [getAsset].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deviceregistry&#46;kotlin&#46;inputs&#46;GetAssetPlainArgs].
     * @return Asset definition.
     */
    public suspend fun getAsset(argument: suspend GetAssetPlainArgsBuilder.() -> Unit):
        GetAssetResult {
        val builder = GetAssetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssetResultToKotlin(getAssetPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve a single Asset Endpoint Profile.
     * Azure REST API version: 2023-11-01-preview.
     * @param argument null
     * @return Asset Endpoint Profile definition.
     */
    public suspend fun getAssetEndpointProfile(argument: GetAssetEndpointProfilePlainArgs):
        GetAssetEndpointProfileResult =
        getAssetEndpointProfileResultToKotlin(getAssetEndpointProfilePlain(argument.toJava()).await())

    /**
     * @see [getAssetEndpointProfile].
     * @param assetEndpointProfileName Asset Endpoint Profile name parameter.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Asset Endpoint Profile definition.
     */
    public suspend fun getAssetEndpointProfile(
        assetEndpointProfileName: String,
        resourceGroupName: String,
    ): GetAssetEndpointProfileResult {
        val argument = GetAssetEndpointProfilePlainArgs(
            assetEndpointProfileName = assetEndpointProfileName,
            resourceGroupName = resourceGroupName,
        )
        return getAssetEndpointProfileResultToKotlin(getAssetEndpointProfilePlain(argument.toJava()).await())
    }

    /**
     * @see [getAssetEndpointProfile].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deviceregistry&#46;kotlin&#46;inputs&#46;GetAssetEndpointProfilePlainArgs].
     * @return Asset Endpoint Profile definition.
     */
    public suspend
    fun getAssetEndpointProfile(argument: suspend GetAssetEndpointProfilePlainArgsBuilder.() -> Unit):
        GetAssetEndpointProfileResult {
        val builder = GetAssetEndpointProfilePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAssetEndpointProfileResultToKotlin(getAssetEndpointProfilePlain(builtArgument.toJava()).await())
    }
}
