@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the Asset Endpoint Profile properties.
 * @property additionalConfiguration Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
 * @property targetAddress The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
 * @property transportAuthentication Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
 * @property userAuthentication Defines the client authentication mechanism to the server.
 */
public data class AssetEndpointProfilePropertiesArgs(
    public val additionalConfiguration: Output<String>? = null,
    public val targetAddress: Output<String>,
    public val transportAuthentication:
    Output<AssetEndpointProfilePropertiesTransportAuthenticationArgs>? = null,
    public val userAuthentication: Output<AssetEndpointProfilePropertiesUserAuthenticationArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesArgs.builder()
            .additionalConfiguration(additionalConfiguration?.applyValue({ args0 -> args0 }))
            .targetAddress(targetAddress.applyValue({ args0 -> args0 }))
            .transportAuthentication(
                transportAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .userAuthentication(
                userAuthentication?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [AssetEndpointProfilePropertiesArgs].
 */
@PulumiTagMarker
public class AssetEndpointProfilePropertiesArgsBuilder internal constructor() {
    private var additionalConfiguration: Output<String>? = null

    private var targetAddress: Output<String>? = null

    private var transportAuthentication:
        Output<AssetEndpointProfilePropertiesTransportAuthenticationArgs>? = null

    private var userAuthentication: Output<AssetEndpointProfilePropertiesUserAuthenticationArgs>? =
        null

    /**
     * @param value Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
     */
    @JvmName("uykrhafxpbqhnrfd")
    public suspend fun additionalConfiguration(`value`: Output<String>) {
        this.additionalConfiguration = value
    }

    /**
     * @param value The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
     */
    @JvmName("iyblwdtjlqenifxc")
    public suspend fun targetAddress(`value`: Output<String>) {
        this.targetAddress = value
    }

    /**
     * @param value Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
     */
    @JvmName("nbcfpjawpeyrubco")
    public suspend
    fun transportAuthentication(`value`: Output<AssetEndpointProfilePropertiesTransportAuthenticationArgs>) {
        this.transportAuthentication = value
    }

    /**
     * @param value Defines the client authentication mechanism to the server.
     */
    @JvmName("nggwynjqstbmdqla")
    public suspend
    fun userAuthentication(`value`: Output<AssetEndpointProfilePropertiesUserAuthenticationArgs>) {
        this.userAuthentication = value
    }

    /**
     * @param value Contains connectivity type specific further configuration (e.g. OPC UA, Modbus, ONVIF).
     */
    @JvmName("chkqxnsdlmlajnic")
    public suspend fun additionalConfiguration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalConfiguration = mapped
    }

    /**
     * @param value The local valid URI specifying the network address/DNS name of a southbound device. The scheme part of the targetAddress URI specifies the type of the device. The additionalConfiguration field holds further connector type specific configuration.
     */
    @JvmName("wuoaravdhfupnoim")
    public suspend fun targetAddress(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetAddress = mapped
    }

    /**
     * @param value Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
     */
    @JvmName("tvtxyiphdvgpgrwf")
    public suspend
    fun transportAuthentication(`value`: AssetEndpointProfilePropertiesTransportAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transportAuthentication = mapped
    }

    /**
     * @param argument Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
     */
    @JvmName("ydbpctfxwgtohjpk")
    public suspend
    fun transportAuthentication(argument: suspend AssetEndpointProfilePropertiesTransportAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped =
            AssetEndpointProfilePropertiesTransportAuthenticationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.transportAuthentication = mapped
    }

    /**
     * @param value Defines the client authentication mechanism to the server.
     */
    @JvmName("bqkwhpgxmtjysgvq")
    public suspend
    fun userAuthentication(`value`: AssetEndpointProfilePropertiesUserAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAuthentication = mapped
    }

    /**
     * @param argument Defines the client authentication mechanism to the server.
     */
    @JvmName("hsyhhageyryqryeh")
    public suspend
    fun userAuthentication(argument: suspend AssetEndpointProfilePropertiesUserAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = AssetEndpointProfilePropertiesUserAuthenticationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.userAuthentication = mapped
    }

    internal fun build(): AssetEndpointProfilePropertiesArgs = AssetEndpointProfilePropertiesArgs(
        additionalConfiguration = additionalConfiguration,
        targetAddress = targetAddress ?: throw PulumiNullFieldException("targetAddress"),
        transportAuthentication = transportAuthentication,
        userAuthentication = userAuthentication,
    )
}
