@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesOwnCertificatesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certPasswordReference Secret Reference Name (Pfx or Pem password)
 * @property certSecretReference Secret Reference name (cert and private key).
 * @property certThumbprint Certificate thumbprint.
 */
public data class AssetEndpointProfilePropertiesOwnCertificatesArgs(
    public val certPasswordReference: Output<String>? = null,
    public val certSecretReference: Output<String>? = null,
    public val certThumbprint: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesOwnCertificatesArgs> {
    override fun toJava():
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesOwnCertificatesArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesOwnCertificatesArgs.builder()
            .certPasswordReference(certPasswordReference?.applyValue({ args0 -> args0 }))
            .certSecretReference(certSecretReference?.applyValue({ args0 -> args0 }))
            .certThumbprint(certThumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssetEndpointProfilePropertiesOwnCertificatesArgs].
 */
@PulumiTagMarker
public class AssetEndpointProfilePropertiesOwnCertificatesArgsBuilder internal constructor() {
    private var certPasswordReference: Output<String>? = null

    private var certSecretReference: Output<String>? = null

    private var certThumbprint: Output<String>? = null

    /**
     * @param value Secret Reference Name (Pfx or Pem password)
     */
    @JvmName("uebbbeulhdstgdwm")
    public suspend fun certPasswordReference(`value`: Output<String>) {
        this.certPasswordReference = value
    }

    /**
     * @param value Secret Reference name (cert and private key).
     */
    @JvmName("lrfrxwevmrdmlhee")
    public suspend fun certSecretReference(`value`: Output<String>) {
        this.certSecretReference = value
    }

    /**
     * @param value Certificate thumbprint.
     */
    @JvmName("ftoykqnvtdbtnbsv")
    public suspend fun certThumbprint(`value`: Output<String>) {
        this.certThumbprint = value
    }

    /**
     * @param value Secret Reference Name (Pfx or Pem password)
     */
    @JvmName("krwksunkfyypnklx")
    public suspend fun certPasswordReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certPasswordReference = mapped
    }

    /**
     * @param value Secret Reference name (cert and private key).
     */
    @JvmName("xiyjddxjtuvovmug")
    public suspend fun certSecretReference(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certSecretReference = mapped
    }

    /**
     * @param value Certificate thumbprint.
     */
    @JvmName("teueautqqdmhvexh")
    public suspend fun certThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certThumbprint = mapped
    }

    internal fun build(): AssetEndpointProfilePropertiesOwnCertificatesArgs =
        AssetEndpointProfilePropertiesOwnCertificatesArgs(
            certPasswordReference = certPasswordReference,
            certSecretReference = certSecretReference,
            certThumbprint = certThumbprint,
        )
}
