@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Defines the username and password references when UsernamePassword user authentication mode is selected.
 * @property passwordReference A reference to secret containing the password.
 * @property usernameReference A reference to secret containing the username.
 */
public data class AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs(
    public val passwordReference: Output<String>,
    public val usernameReference: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs> {
    override fun toJava():
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs.builder()
            .passwordReference(passwordReference.applyValue({ args0 -> args0 }))
            .usernameReference(usernameReference.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs].
 */
@PulumiTagMarker
public class AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgsBuilder internal
constructor() {
    private var passwordReference: Output<String>? = null

    private var usernameReference: Output<String>? = null

    /**
     * @param value A reference to secret containing the password.
     */
    @JvmName("texqkyhqghriqjis")
    public suspend fun passwordReference(`value`: Output<String>) {
        this.passwordReference = value
    }

    /**
     * @param value A reference to secret containing the username.
     */
    @JvmName("airqbjexpaxrhlat")
    public suspend fun usernameReference(`value`: Output<String>) {
        this.usernameReference = value
    }

    /**
     * @param value A reference to secret containing the password.
     */
    @JvmName("nrpqoglojeydrbvl")
    public suspend fun passwordReference(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwordReference = mapped
    }

    /**
     * @param value A reference to secret containing the username.
     */
    @JvmName("bgjemojxqdtpsvfb")
    public suspend fun usernameReference(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.usernameReference = mapped
    }

    internal fun build(): AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs =
        AssetEndpointProfilePropertiesUsernamePasswordCredentialsArgs(
            passwordReference = passwordReference ?: throw PulumiNullFieldException("passwordReference"),
            usernameReference = usernameReference ?: throw PulumiNullFieldException("usernameReference"),
        )
}
