@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.inputs

import com.pulumi.azurenative.deviceregistry.inputs.AssetExtendedLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The extended location.
 * @property name The extended location name.
 * @property type The extended location type.
 */
public data class AssetExtendedLocationArgs(
    public val name: Output<String>? = null,
    public val type: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deviceregistry.inputs.AssetExtendedLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.deviceregistry.inputs.AssetExtendedLocationArgs =
        com.pulumi.azurenative.deviceregistry.inputs.AssetExtendedLocationArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AssetExtendedLocationArgs].
 */
@PulumiTagMarker
public class AssetExtendedLocationArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The extended location name.
     */
    @JvmName("yyoipppurewtpxoj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The extended location type.
     */
    @JvmName("nrafbgspolnnenpl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The extended location name.
     */
    @JvmName("lytyykgiihdifemv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The extended location type.
     */
    @JvmName("roxlimxtwifmdqgy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AssetExtendedLocationArgs = AssetExtendedLocationArgs(
        name = name,
        type = type,
    )
}
