@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certPasswordReference Secret Reference Name (Pfx or Pem password)
 * @property certSecretReference Secret Reference name (cert and private key).
 * @property certThumbprint Certificate thumbprint.
 */
public data class AssetEndpointProfilePropertiesResponseOwnCertificates(
    public val certPasswordReference: String? = null,
    public val certSecretReference: String? = null,
    public val certThumbprint: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetEndpointProfilePropertiesResponseOwnCertificates):
            AssetEndpointProfilePropertiesResponseOwnCertificates =
            AssetEndpointProfilePropertiesResponseOwnCertificates(
                certPasswordReference = javaType.certPasswordReference().map({ args0 -> args0 }).orElse(null),
                certSecretReference = javaType.certSecretReference().map({ args0 -> args0 }).orElse(null),
                certThumbprint = javaType.certThumbprint().map({ args0 -> args0 }).orElse(null),
            )
    }
}
