@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the authentication mechanism for the southbound connector connecting to the shop floor/OT device.
 * @property ownCertificates Defines a reference to a secret which contains all certificates and private keys that can be used by the southbound connector connecting to the shop floor/OT device. The accepted extensions are .der for certificates and .pfx/.pem for private keys.
 */
public data class AssetEndpointProfilePropertiesResponseTransportAuthentication(
    public val ownCertificates: List<AssetEndpointProfilePropertiesResponseOwnCertificates>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetEndpointProfilePropertiesResponseTransportAuthentication):
            AssetEndpointProfilePropertiesResponseTransportAuthentication =
            AssetEndpointProfilePropertiesResponseTransportAuthentication(
                ownCertificates = javaType.ownCertificates().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetEndpointProfilePropertiesResponseOwnCertificates.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
