@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deviceregistry.kotlin.outputs

import kotlin.Any
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Asset resource properties.
 * @property assetEndpointProfileUri A reference to the asset endpoint profile (connection information) used by brokers to connect to an endpoint that provides data points for this asset. Must have the format <ModuleCR.metadata.namespace>/<ModuleCR.metadata.name>.
 * @property assetType Resource path to asset type (model) definition.
 * @property attributes A set of key-value pairs that contain custom attributes set by the customer.
 * @property dataPoints Array of data points that are part of the asset. Each data point can reference an asset type capability and have per-data point configuration. See below for more details for the definition of the dataPoints element.
 * @property defaultDataPointsConfiguration Protocol-specific default configuration for all data points. Each data point can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
 * @property defaultEventsConfiguration Protocol-specific default configuration for all events. Each event can have its own configuration that overrides the default settings here. This assumes that each asset instance has one protocol.
 * @property description Human-readable description of the asset.
 * @property displayName Human-readable display name.
 * @property documentationUri Reference to the documentation.
 * @property enabled Enabled/Disabled status of the asset.
 * @property events Array of events that are part of the asset. Each event can reference an asset type capability and have per-event configuration. See below for more details about the definition of the events element.
 * @property externalAssetId Asset id provided by the customer.
 * @property hardwareRevision Revision number of the hardware.
 * @property manufacturer Asset manufacturer name.
 * @property manufacturerUri Asset manufacturer URI.
 * @property model Asset model name.
 * @property productCode Asset product code.
 * @property provisioningState Provisioning state of the resource.
 * @property serialNumber Asset serial number.
 * @property softwareRevision Revision number of the software.
 * @property status Read only object to reflect changes that have occurred on the Edge. Similar to Kubernetes status property for custom resources.
 * @property uuid Globally unique, immutable, non-reusable id.
 * @property version An integer that is incremented each time the resource is modified.
 */
public data class AssetResponseProperties(
    public val assetEndpointProfileUri: String,
    public val assetType: String? = null,
    public val attributes: Any? = null,
    public val dataPoints: List<AssetPropertiesResponseDataPoints>? = null,
    public val defaultDataPointsConfiguration: String? = null,
    public val defaultEventsConfiguration: String? = null,
    public val description: String? = null,
    public val displayName: String? = null,
    public val documentationUri: String? = null,
    public val enabled: Boolean? = null,
    public val events: List<AssetPropertiesResponseEvents>? = null,
    public val externalAssetId: String? = null,
    public val hardwareRevision: String? = null,
    public val manufacturer: String? = null,
    public val manufacturerUri: String? = null,
    public val model: String? = null,
    public val productCode: String? = null,
    public val provisioningState: String,
    public val serialNumber: String? = null,
    public val softwareRevision: String? = null,
    public val status: AssetPropertiesResponseStatus,
    public val uuid: String,
    public val version: Int,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.deviceregistry.outputs.AssetResponseProperties):
            AssetResponseProperties = AssetResponseProperties(
            assetEndpointProfileUri = javaType.assetEndpointProfileUri(),
            assetType = javaType.assetType().map({ args0 -> args0 }).orElse(null),
            attributes = javaType.attributes().map({ args0 -> args0 }).orElse(null),
            dataPoints = javaType.dataPoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetPropertiesResponseDataPoints.Companion.toKotlin(args0)
                })
            }),
            defaultDataPointsConfiguration = javaType.defaultDataPointsConfiguration().map({ args0 ->
                args0
            }).orElse(null),
            defaultEventsConfiguration = javaType.defaultEventsConfiguration().map({ args0 ->
                args0
            }).orElse(null),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            displayName = javaType.displayName().map({ args0 -> args0 }).orElse(null),
            documentationUri = javaType.documentationUri().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled().map({ args0 -> args0 }).orElse(null),
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetPropertiesResponseEvents.Companion.toKotlin(args0)
                })
            }),
            externalAssetId = javaType.externalAssetId().map({ args0 -> args0 }).orElse(null),
            hardwareRevision = javaType.hardwareRevision().map({ args0 -> args0 }).orElse(null),
            manufacturer = javaType.manufacturer().map({ args0 -> args0 }).orElse(null),
            manufacturerUri = javaType.manufacturerUri().map({ args0 -> args0 }).orElse(null),
            model = javaType.model().map({ args0 -> args0 }).orElse(null),
            productCode = javaType.productCode().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            serialNumber = javaType.serialNumber().map({ args0 -> args0 }).orElse(null),
            softwareRevision = javaType.softwareRevision().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().let({ args0 ->
                com.pulumi.azurenative.deviceregistry.kotlin.outputs.AssetPropertiesResponseStatus.Companion.toKotlin(args0)
            }),
            uuid = javaType.uuid(),
            version = javaType.version(),
        )
    }
}
