@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin

import com.pulumi.azurenative.devices.kotlin.outputs.CertificatePropertiesResponse
import com.pulumi.azurenative.devices.kotlin.outputs.CertificatePropertiesResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Certificate].
 */
@PulumiTagMarker
public class CertificateResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CertificateArgs = CertificateArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CertificateArgsBuilder.() -> Unit) {
        val builder = CertificateArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Certificate {
        val builtJavaResource = com.pulumi.azurenative.devices.Certificate(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Certificate(builtJavaResource)
    }
}

/**
 * The X509 Certificate.
 * Azure REST API version: 2022-04-30-preview. Prior API version in Azure Native 1.x: 2020-08-31.
 * Other available API versions: 2020-04-01, 2022-11-15-preview, 2023-06-30, 2023-06-30-preview.
 * ## Example Usage
 * ### Certificates_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var certificate = new AzureNative.Devices.Certificate("certificate", new()
 *     {
 *         CertificateName = "cert",
 *         Properties = new AzureNative.Devices.Inputs.CertificatePropertiesArgs
 *         {
 *             Certificate = "############################################",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         ResourceName = "iothub",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/devices/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := devices.NewCertificate(ctx, "certificate", &devices.CertificateArgs{
 * 			CertificateName: pulumi.String("cert"),
 * 			Properties: &devices.CertificatePropertiesArgs{
 * 				Certificate: pulumi.String("############################################"),
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			ResourceName:      pulumi.String("iothub"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.devices.Certificate;
 * import com.pulumi.azurenative.devices.CertificateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var certificate = new Certificate("certificate", CertificateArgs.builder()
 *             .certificateName("cert")
 *             .properties(Map.of("certificate", "############################################"))
 *             .resourceGroupName("myResourceGroup")
 *             .resourceName("iothub")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:devices:Certificate cert /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/certificates/{certificateName}
 * ```
 */
public class Certificate internal constructor(
    override val javaResource: com.pulumi.azurenative.devices.Certificate,
) : KotlinCustomResource(javaResource, CertificateMapper) {
    /**
     * The entity tag.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The name of the certificate.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The description of an X509 CA Certificate.
     */
    public val properties: Output<CertificatePropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object CertificateMapper : ResourceMapper<Certificate> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.devices.Certificate::class == javaResource::class

    override fun map(javaResource: Resource): Certificate = Certificate(
        javaResource as
            com.pulumi.azurenative.devices.Certificate,
    )
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Certificate].
 */
public suspend fun certificate(name: String, block: suspend CertificateResourceBuilder.() -> Unit):
    Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Certificate].
 * @param name The _unique_ name of the resulting resource.
 */
public fun certificate(name: String): Certificate {
    val builder = CertificateResourceBuilder()
    builder.name(name)
    return builder.build()
}
