@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The capabilities and features enabled for the IoT hub.
 */
public enum class Capabilities(
    public val javaValue: com.pulumi.azurenative.devices.enums.Capabilities,
) : ConvertibleToJava<com.pulumi.azurenative.devices.enums.Capabilities> {
    None(com.pulumi.azurenative.devices.enums.Capabilities.None),
    DeviceManagement(com.pulumi.azurenative.devices.enums.Capabilities.DeviceManagement),
    ;

    override fun toJava(): com.pulumi.azurenative.devices.enums.Capabilities = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.enums.Capabilities): Capabilities =
            Capabilities.values().first { it.javaValue == javaType }
    }
}
