@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Current state of the provisioning service.
 */
public enum class State(
    public val javaValue: com.pulumi.azurenative.devices.enums.State,
) : ConvertibleToJava<com.pulumi.azurenative.devices.enums.State> {
    Activating(com.pulumi.azurenative.devices.enums.State.Activating),
    Active(com.pulumi.azurenative.devices.enums.State.Active),
    Deleting(com.pulumi.azurenative.devices.enums.State.Deleting),
    Deleted(com.pulumi.azurenative.devices.enums.State.Deleted),
    ActivationFailed(com.pulumi.azurenative.devices.enums.State.ActivationFailed),
    DeletionFailed(com.pulumi.azurenative.devices.enums.State.DeletionFailed),
    Transitioning(com.pulumi.azurenative.devices.enums.State.Transitioning),
    Suspending(com.pulumi.azurenative.devices.enums.State.Suspending),
    Suspended(com.pulumi.azurenative.devices.enums.State.Suspended),
    Resuming(com.pulumi.azurenative.devices.enums.State.Resuming),
    FailingOver(com.pulumi.azurenative.devices.enums.State.FailingOver),
    FailoverFailed(com.pulumi.azurenative.devices.enums.State.FailoverFailed),
    ;

    override fun toJava(): com.pulumi.azurenative.devices.enums.State = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.enums.State): State =
            State.values().first { it.javaValue == javaType }
    }
}
