@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.ListIotHubResourceKeysForKeyNamePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyName The name of the shared access policy.
 * @property resourceGroupName The name of the resource group that contains the IoT hub.
 * @property resourceName The name of the IoT hub.
 */
public data class ListIotHubResourceKeysForKeyNamePlainArgs(
    public val keyName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.devices.inputs.ListIotHubResourceKeysForKeyNamePlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.devices.inputs.ListIotHubResourceKeysForKeyNamePlainArgs =
        com.pulumi.azurenative.devices.inputs.ListIotHubResourceKeysForKeyNamePlainArgs.builder()
            .keyName(keyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListIotHubResourceKeysForKeyNamePlainArgs].
 */
@PulumiTagMarker
public class ListIotHubResourceKeysForKeyNamePlainArgsBuilder internal constructor() {
    private var keyName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value The name of the shared access policy.
     */
    @JvmName("rlgeydprxemutinq")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.keyName = mapped
    }

    /**
     * @param value The name of the resource group that contains the IoT hub.
     */
    @JvmName("vcbbgqprabfkodbo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the IoT hub.
     */
    @JvmName("lfuflwcsjpvchmqi")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): ListIotHubResourceKeysForKeyNamePlainArgs =
        ListIotHubResourceKeysForKeyNamePlainArgs(
            keyName = keyName ?: throw PulumiNullFieldException("keyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
