@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.ManagedIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties of the Managed identity.
 * @property userAssignedIdentity The user assigned identity.
 */
public data class ManagedIdentityArgs(
    public val userAssignedIdentity: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.ManagedIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.ManagedIdentityArgs =
        com.pulumi.azurenative.devices.inputs.ManagedIdentityArgs.builder()
            .userAssignedIdentity(userAssignedIdentity?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIdentityArgs].
 */
@PulumiTagMarker
public class ManagedIdentityArgsBuilder internal constructor() {
    private var userAssignedIdentity: Output<String>? = null

    /**
     * @param value The user assigned identity.
     */
    @JvmName("bguxxhycjpxtolbb")
    public suspend fun userAssignedIdentity(`value`: Output<String>) {
        this.userAssignedIdentity = value
    }

    /**
     * @param value The user assigned identity.
     */
    @JvmName("bugfwfbrtnidyajf")
    public suspend fun userAssignedIdentity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentity = mapped
    }

    internal fun build(): ManagedIdentityArgs = ManagedIdentityArgs(
        userAssignedIdentity = userAssignedIdentity,
    )
}
