@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties of a private endpoint connection
 * @property privateLinkServiceConnectionState The current state of a private endpoint connection
 */
public data class PrivateEndpointConnectionPropertiesArgs(
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.PrivateEndpointConnectionPropertiesArgs.builder()
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [PrivateEndpointConnectionPropertiesArgs].
 */
@PulumiTagMarker
public class PrivateEndpointConnectionPropertiesArgsBuilder internal constructor() {
    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    /**
     * @param value The current state of a private endpoint connection
     */
    @JvmName("fxeadqptkjkiwvyj")
    public suspend
    fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The current state of a private endpoint connection
     */
    @JvmName("fcorcnmtgdttnidk")
    public suspend
    fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument The current state of a private endpoint connection
     */
    @JvmName("ahqgyuugtfcvgawi")
    public suspend
    fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    internal fun build(): PrivateEndpointConnectionPropertiesArgs =
        PrivateEndpointConnectionPropertiesArgs(
            privateLinkServiceConnectionState = privateLinkServiceConnectionState ?: throw
                PulumiNullFieldException("privateLinkServiceConnectionState"),
        )
}
