@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.RoutePropertiesArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.RoutingSource
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a routing rule that your IoT hub uses to route messages to endpoints.
 * @property condition The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
 * @property endpointNames The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
 * @property isEnabled Used to specify whether a route is enabled.
 * @property name The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
 * @property source The source that the routing rule is to be applied to, such as DeviceMessages.
 */
public data class RoutePropertiesArgs(
    public val condition: Output<String>? = null,
    public val endpointNames: Output<List<String>>,
    public val isEnabled: Output<Boolean>,
    public val name: Output<String>,
    public val source: Output<Either<String, RoutingSource>>,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.RoutePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.RoutePropertiesArgs =
        com.pulumi.azurenative.devices.inputs.RoutePropertiesArgs.builder()
            .condition(condition?.applyValue({ args0 -> args0 }))
            .endpointNames(endpointNames.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .isEnabled(isEnabled.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .source(
                source.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [RoutePropertiesArgs].
 */
@PulumiTagMarker
public class RoutePropertiesArgsBuilder internal constructor() {
    private var condition: Output<String>? = null

    private var endpointNames: Output<List<String>>? = null

    private var isEnabled: Output<Boolean>? = null

    private var name: Output<String>? = null

    private var source: Output<Either<String, RoutingSource>>? = null

    /**
     * @param value The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
     */
    @JvmName("dbuhymfxhehtxrgb")
    public suspend fun condition(`value`: Output<String>) {
        this.condition = value
    }

    /**
     * @param value The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
     */
    @JvmName("syopbxhlrwmkhdlx")
    public suspend fun endpointNames(`value`: Output<List<String>>) {
        this.endpointNames = value
    }

    @JvmName("emoyjnxuickjixnt")
    public suspend fun endpointNames(vararg values: Output<String>) {
        this.endpointNames = Output.all(values.asList())
    }

    /**
     * @param values The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
     */
    @JvmName("inehjkkaohqoyhvt")
    public suspend fun endpointNames(values: List<Output<String>>) {
        this.endpointNames = Output.all(values)
    }

    /**
     * @param value Used to specify whether a route is enabled.
     */
    @JvmName("jtyxbmxpdouhhppn")
    public suspend fun isEnabled(`value`: Output<Boolean>) {
        this.isEnabled = value
    }

    /**
     * @param value The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
     */
    @JvmName("igjcqdavbiycyepi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The source that the routing rule is to be applied to, such as DeviceMessages.
     */
    @JvmName("lntbmnonfuqantho")
    public suspend fun source(`value`: Output<Either<String, RoutingSource>>) {
        this.source = value
    }

    /**
     * @param value The condition that is evaluated to apply the routing rule. If no condition is provided, it evaluates to true by default. For grammar, see: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language
     */
    @JvmName("fnurcqfjtlwoiqme")
    public suspend fun condition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.condition = mapped
    }

    /**
     * @param value The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
     */
    @JvmName("buetxjogbuwaagyb")
    public suspend fun endpointNames(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointNames = mapped
    }

    /**
     * @param values The list of endpoints to which messages that satisfy the condition are routed. Currently only one endpoint is allowed.
     */
    @JvmName("aghxjmhagnfbhduw")
    public suspend fun endpointNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endpointNames = mapped
    }

    /**
     * @param value Used to specify whether a route is enabled.
     */
    @JvmName("nyygkpiqwvxwaifw")
    public suspend fun isEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isEnabled = mapped
    }

    /**
     * @param value The name of the route. The name can only include alphanumeric characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
     */
    @JvmName("bociocnydxdbjaoc")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The source that the routing rule is to be applied to, such as DeviceMessages.
     */
    @JvmName("oxteeyyyfauchvqn")
    public suspend fun source(`value`: Either<String, RoutingSource>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source that the routing rule is to be applied to, such as DeviceMessages.
     */
    @JvmName("fevrciuvimkpgigt")
    public fun source(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RoutingSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    /**
     * @param value The source that the routing rule is to be applied to, such as DeviceMessages.
     */
    @JvmName("mtudhmvcdxglofbv")
    public fun source(`value`: RoutingSource) {
        val toBeMapped = Either.ofRight<String, RoutingSource>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.source = mapped
    }

    internal fun build(): RoutePropertiesArgs = RoutePropertiesArgs(
        condition = condition,
        endpointNames = endpointNames ?: throw PulumiNullFieldException("endpointNames"),
        isEnabled = isEnabled ?: throw PulumiNullFieldException("isEnabled"),
        name = name ?: throw PulumiNullFieldException("name"),
        source = source ?: throw PulumiNullFieldException("source"),
    )
}
