@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.RoutingEventHubPropertiesArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties related to an event hub endpoint.
 * @property authenticationType Method used to authenticate against the event hub endpoint
 * @property connectionString The connection string of the event hub endpoint.
 * @property endpointUri The url of the event hub endpoint. It must include the protocol sb://
 * @property entityPath Event hub name on the event hub namespace
 * @property id Id of the event hub endpoint
 * @property identity Managed identity properties of routing event hub endpoint.
 * @property name The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
 * @property resourceGroup The name of the resource group of the event hub endpoint.
 * @property subscriptionId The subscription identifier of the event hub endpoint.
 */
public data class RoutingEventHubPropertiesArgs(
    public val authenticationType: Output<Either<String, AuthenticationType>>? = null,
    public val connectionString: Output<String>? = null,
    public val endpointUri: Output<String>? = null,
    public val entityPath: Output<String>? = null,
    public val id: Output<String>? = null,
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val name: Output<String>,
    public val resourceGroup: Output<String>? = null,
    public val subscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.RoutingEventHubPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.RoutingEventHubPropertiesArgs =
        com.pulumi.azurenative.devices.inputs.RoutingEventHubPropertiesArgs.builder()
            .authenticationType(
                authenticationType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectionString(connectionString?.applyValue({ args0 -> args0 }))
            .endpointUri(endpointUri?.applyValue({ args0 -> args0 }))
            .entityPath(entityPath?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .resourceGroup(resourceGroup?.applyValue({ args0 -> args0 }))
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RoutingEventHubPropertiesArgs].
 */
@PulumiTagMarker
public class RoutingEventHubPropertiesArgsBuilder internal constructor() {
    private var authenticationType: Output<Either<String, AuthenticationType>>? = null

    private var connectionString: Output<String>? = null

    private var endpointUri: Output<String>? = null

    private var entityPath: Output<String>? = null

    private var id: Output<String>? = null

    private var identity: Output<ManagedIdentityArgs>? = null

    private var name: Output<String>? = null

    private var resourceGroup: Output<String>? = null

    private var subscriptionId: Output<String>? = null

    /**
     * @param value Method used to authenticate against the event hub endpoint
     */
    @JvmName("mhifjixcxpgttmgv")
    public suspend fun authenticationType(`value`: Output<Either<String, AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The connection string of the event hub endpoint.
     */
    @JvmName("opgsfvgxihmiquuw")
    public suspend fun connectionString(`value`: Output<String>) {
        this.connectionString = value
    }

    /**
     * @param value The url of the event hub endpoint. It must include the protocol sb://
     */
    @JvmName("qstcguixunnmtfie")
    public suspend fun endpointUri(`value`: Output<String>) {
        this.endpointUri = value
    }

    /**
     * @param value Event hub name on the event hub namespace
     */
    @JvmName("nhpeviusssxuimde")
    public suspend fun entityPath(`value`: Output<String>) {
        this.entityPath = value
    }

    /**
     * @param value Id of the event hub endpoint
     */
    @JvmName("vfvushihbxqdafmk")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Managed identity properties of routing event hub endpoint.
     */
    @JvmName("eolvwvqgslgoaixx")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
     */
    @JvmName("eusqbmrhpouoyjri")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The name of the resource group of the event hub endpoint.
     */
    @JvmName("dpbhupcffvckdipk")
    public suspend fun resourceGroup(`value`: Output<String>) {
        this.resourceGroup = value
    }

    /**
     * @param value The subscription identifier of the event hub endpoint.
     */
    @JvmName("kwjymtdlhytfbcvb")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Method used to authenticate against the event hub endpoint
     */
    @JvmName("looxihscovqrimoa")
    public suspend fun authenticationType(`value`: Either<String, AuthenticationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Method used to authenticate against the event hub endpoint
     */
    @JvmName("iyihqfqtuyrqaaej")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Method used to authenticate against the event hub endpoint
     */
    @JvmName("qimdfayxovlnfjcv")
    public fun authenticationType(`value`: AuthenticationType) {
        val toBeMapped = Either.ofRight<String, AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The connection string of the event hub endpoint.
     */
    @JvmName("bgeeqkdwbbsidcuf")
    public suspend fun connectionString(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The url of the event hub endpoint. It must include the protocol sb://
     */
    @JvmName("kjgiyftpxdehsfph")
    public suspend fun endpointUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointUri = mapped
    }

    /**
     * @param value Event hub name on the event hub namespace
     */
    @JvmName("vhoqwrtwwxtrdhyv")
    public suspend fun entityPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entityPath = mapped
    }

    /**
     * @param value Id of the event hub endpoint
     */
    @JvmName("btwvyhimrnkplysy")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Managed identity properties of routing event hub endpoint.
     */
    @JvmName("hnpmniabfthebfnx")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Managed identity properties of routing event hub endpoint.
     */
    @JvmName("goshhpfehllkvxit")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The name that identifies this endpoint. The name can only include alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64 characters. The following names are reserved:  events, fileNotifications, $default. Endpoint names must be unique across endpoint types.
     */
    @JvmName("nmdumkwyniboldnj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The name of the resource group of the event hub endpoint.
     */
    @JvmName("ckgmoylwibeubnib")
    public suspend fun resourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroup = mapped
    }

    /**
     * @param value The subscription identifier of the event hub endpoint.
     */
    @JvmName("dsusmsisubduupqn")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    internal fun build(): RoutingEventHubPropertiesArgs = RoutingEventHubPropertiesArgs(
        authenticationType = authenticationType,
        connectionString = connectionString,
        endpointUri = endpointUri,
        entityPath = entityPath,
        id = id,
        identity = identity,
        name = name ?: throw PulumiNullFieldException("name"),
        resourceGroup = resourceGroup,
        subscriptionId = subscriptionId,
    )
}
