@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.inputs

import com.pulumi.azurenative.devices.inputs.TargetIpFilterRuleArgs.builder
import com.pulumi.azurenative.devices.kotlin.enums.IpFilterActionType
import com.pulumi.azurenative.devices.kotlin.enums.IpFilterTargetType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The IP filter rules for a provisioning Service.
 * @property action The desired action for requests captured by this rule.
 * @property filterName The name of the IP filter rule.
 * @property ipMask A string that contains the IP address range in CIDR notation for the rule.
 * @property target Target for requests captured by this rule.
 */
public data class TargetIpFilterRuleArgs(
    public val action: Output<IpFilterActionType>,
    public val filterName: Output<String>,
    public val ipMask: Output<String>,
    public val target: Output<IpFilterTargetType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.devices.inputs.TargetIpFilterRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.devices.inputs.TargetIpFilterRuleArgs =
        com.pulumi.azurenative.devices.inputs.TargetIpFilterRuleArgs.builder()
            .action(action.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .filterName(filterName.applyValue({ args0 -> args0 }))
            .ipMask(ipMask.applyValue({ args0 -> args0 }))
            .target(target?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [TargetIpFilterRuleArgs].
 */
@PulumiTagMarker
public class TargetIpFilterRuleArgsBuilder internal constructor() {
    private var action: Output<IpFilterActionType>? = null

    private var filterName: Output<String>? = null

    private var ipMask: Output<String>? = null

    private var target: Output<IpFilterTargetType>? = null

    /**
     * @param value The desired action for requests captured by this rule.
     */
    @JvmName("mtwfguvlyjggnaam")
    public suspend fun action(`value`: Output<IpFilterActionType>) {
        this.action = value
    }

    /**
     * @param value The name of the IP filter rule.
     */
    @JvmName("evmvkddphfsvevth")
    public suspend fun filterName(`value`: Output<String>) {
        this.filterName = value
    }

    /**
     * @param value A string that contains the IP address range in CIDR notation for the rule.
     */
    @JvmName("jnnliwitjwwkhlqg")
    public suspend fun ipMask(`value`: Output<String>) {
        this.ipMask = value
    }

    /**
     * @param value Target for requests captured by this rule.
     */
    @JvmName("usfatabbxajgbxvx")
    public suspend fun target(`value`: Output<IpFilterTargetType>) {
        this.target = value
    }

    /**
     * @param value The desired action for requests captured by this rule.
     */
    @JvmName("uxkljgykwhxerjku")
    public suspend fun action(`value`: IpFilterActionType) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value The name of the IP filter rule.
     */
    @JvmName("kloaeptgrkdhgdqs")
    public suspend fun filterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filterName = mapped
    }

    /**
     * @param value A string that contains the IP address range in CIDR notation for the rule.
     */
    @JvmName("jmynjmkuhrcfaarj")
    public suspend fun ipMask(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipMask = mapped
    }

    /**
     * @param value Target for requests captured by this rule.
     */
    @JvmName("jwowkctxargqqkjh")
    public suspend fun target(`value`: IpFilterTargetType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.target = mapped
    }

    internal fun build(): TargetIpFilterRuleArgs = TargetIpFilterRuleArgs(
        action = action ?: throw PulumiNullFieldException("action"),
        filterName = filterName ?: throw PulumiNullFieldException("filterName"),
        ipMask = ipMask ?: throw PulumiNullFieldException("ipMask"),
        target = target,
    )
}
