@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The X509 Certificate.
 * @property etag The entity tag.
 * @property id The resource identifier.
 * @property name The name of the certificate.
 * @property properties The description of an X509 CA Certificate.
 * @property type The resource type.
 */
public data class GetCertificateResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val properties: CertificatePropertiesResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.GetCertificateResult):
            GetCertificateResult = GetCertificateResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.devices.kotlin.outputs.CertificatePropertiesResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
