@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.devices.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * The properties of the EventHubConsumerGroupInfo object.
 * @property etag The etag.
 * @property id The Event Hub-compatible consumer group identifier.
 * @property name The Event Hub-compatible consumer group name.
 * @property properties The tags.
 * @property type the resource type.
 */
public data class GetIotHubResourceEventHubConsumerGroupResult(
    public val etag: String,
    public val id: String,
    public val name: String,
    public val properties: Any,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.devices.outputs.GetIotHubResourceEventHubConsumerGroupResult):
            GetIotHubResourceEventHubConsumerGroupResult = GetIotHubResourceEventHubConsumerGroupResult(
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties(),
            type = javaType.type(),
        )
    }
}
